/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.health.model.EventType;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class EventTypeMarshaller {
    private static final MarshallingInfo<String> SERVICE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("service").isBinary(false).build();
    private static final MarshallingInfo<String> CODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("code").isBinary(false).build();
    private static final MarshallingInfo<String> CATEGORY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("category").isBinary(false).build();
    private static final EventTypeMarshaller INSTANCE = new EventTypeMarshaller();

    private EventTypeMarshaller() {
    }

    public static EventTypeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(EventType eventType, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)eventType, (String)"eventType");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)eventType.service(), SERVICE_BINDING);
            protocolMarshaller.marshall((Object)eventType.code(), CODE_BINDING);
            protocolMarshaller.marshall((Object)eventType.categoryAsString(), CATEGORY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

