/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.health.model.EventTypeFilter;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class EventTypeFilterMarshaller {
    private static final MarshallingInfo<List> EVENTTYPECODES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("eventTypeCodes").isBinary(false).build();
    private static final MarshallingInfo<List> SERVICES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("services").isBinary(false).build();
    private static final MarshallingInfo<List> EVENTTYPECATEGORIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("eventTypeCategories").isBinary(false).build();
    private static final EventTypeFilterMarshaller INSTANCE = new EventTypeFilterMarshaller();

    private EventTypeFilterMarshaller() {
    }

    public static EventTypeFilterMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(EventTypeFilter eventTypeFilter, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)eventTypeFilter, (String)"eventTypeFilter");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(eventTypeFilter.eventTypeCodes(), EVENTTYPECODES_BINDING);
            protocolMarshaller.marshall(eventTypeFilter.services(), SERVICES_BINDING);
            protocolMarshaller.marshall(eventTypeFilter.eventTypeCategoriesAsStrings(), EVENTTYPECATEGORIES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

