/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.health.model.Event;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class EventMarshaller {
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").isBinary(false).build();
    private static final MarshallingInfo<String> SERVICE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("service").isBinary(false).build();
    private static final MarshallingInfo<String> EVENTTYPECODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("eventTypeCode").isBinary(false).build();
    private static final MarshallingInfo<String> EVENTTYPECATEGORY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("eventTypeCategory").isBinary(false).build();
    private static final MarshallingInfo<String> REGION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("region").isBinary(false).build();
    private static final MarshallingInfo<String> AVAILABILITYZONE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("availabilityZone").isBinary(false).build();
    private static final MarshallingInfo<Instant> STARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("startTime").isBinary(false).build();
    private static final MarshallingInfo<Instant> ENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("endTime").isBinary(false).build();
    private static final MarshallingInfo<Instant> LASTUPDATEDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastUpdatedTime").isBinary(false).build();
    private static final MarshallingInfo<String> STATUSCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("statusCode").isBinary(false).build();
    private static final EventMarshaller INSTANCE = new EventMarshaller();

    private EventMarshaller() {
    }

    public static EventMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Event event, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)event, (String)"event");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)event.arn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)event.service(), SERVICE_BINDING);
            protocolMarshaller.marshall((Object)event.eventTypeCode(), EVENTTYPECODE_BINDING);
            protocolMarshaller.marshall((Object)event.eventTypeCategoryAsString(), EVENTTYPECATEGORY_BINDING);
            protocolMarshaller.marshall((Object)event.region(), REGION_BINDING);
            protocolMarshaller.marshall((Object)event.availabilityZone(), AVAILABILITYZONE_BINDING);
            protocolMarshaller.marshall((Object)event.startTime(), STARTTIME_BINDING);
            protocolMarshaller.marshall((Object)event.endTime(), ENDTIME_BINDING);
            protocolMarshaller.marshall((Object)event.lastUpdatedTime(), LASTUPDATEDTIME_BINDING);
            protocolMarshaller.marshall((Object)event.statusCodeAsString(), STATUSCODE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

