/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.health.model.EventFilter;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class EventFilterMarshaller {
    private static final MarshallingInfo<List> EVENTARNS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("eventArns").isBinary(false).build();
    private static final MarshallingInfo<List> EVENTTYPECODES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("eventTypeCodes").isBinary(false).build();
    private static final MarshallingInfo<List> SERVICES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("services").isBinary(false).build();
    private static final MarshallingInfo<List> REGIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("regions").isBinary(false).build();
    private static final MarshallingInfo<List> AVAILABILITYZONES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("availabilityZones").isBinary(false).build();
    private static final MarshallingInfo<List> STARTTIMES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("startTimes").isBinary(false).build();
    private static final MarshallingInfo<List> ENDTIMES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("endTimes").isBinary(false).build();
    private static final MarshallingInfo<List> LASTUPDATEDTIMES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastUpdatedTimes").isBinary(false).build();
    private static final MarshallingInfo<List> ENTITYARNS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("entityArns").isBinary(false).build();
    private static final MarshallingInfo<List> ENTITYVALUES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("entityValues").isBinary(false).build();
    private static final MarshallingInfo<List> EVENTTYPECATEGORIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("eventTypeCategories").isBinary(false).build();
    private static final MarshallingInfo<List> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tags").isBinary(false).build();
    private static final MarshallingInfo<List> EVENTSTATUSCODES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("eventStatusCodes").isBinary(false).build();
    private static final EventFilterMarshaller INSTANCE = new EventFilterMarshaller();

    private EventFilterMarshaller() {
    }

    public static EventFilterMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(EventFilter eventFilter, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)eventFilter, (String)"eventFilter");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(eventFilter.eventArns(), EVENTARNS_BINDING);
            protocolMarshaller.marshall(eventFilter.eventTypeCodes(), EVENTTYPECODES_BINDING);
            protocolMarshaller.marshall(eventFilter.services(), SERVICES_BINDING);
            protocolMarshaller.marshall(eventFilter.regions(), REGIONS_BINDING);
            protocolMarshaller.marshall(eventFilter.availabilityZones(), AVAILABILITYZONES_BINDING);
            protocolMarshaller.marshall(eventFilter.startTimes(), STARTTIMES_BINDING);
            protocolMarshaller.marshall(eventFilter.endTimes(), ENDTIMES_BINDING);
            protocolMarshaller.marshall(eventFilter.lastUpdatedTimes(), LASTUPDATEDTIMES_BINDING);
            protocolMarshaller.marshall(eventFilter.entityArns(), ENTITYARNS_BINDING);
            protocolMarshaller.marshall(eventFilter.entityValues(), ENTITYVALUES_BINDING);
            protocolMarshaller.marshall(eventFilter.eventTypeCategoriesAsStrings(), EVENTTYPECATEGORIES_BINDING);
            protocolMarshaller.marshall(eventFilter.tags(), TAGS_BINDING);
            protocolMarshaller.marshall(eventFilter.eventStatusCodesAsStrings(), EVENTSTATUSCODES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

