/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.health.model.EventDetails;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class EventDetailsMarshaller {
    private static final MarshallingInfo<StructuredPojo> EVENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("event").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> EVENTDESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("eventDescription").isBinary(false).build();
    private static final MarshallingInfo<Map> EVENTMETADATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("eventMetadata").isBinary(false).build();
    private static final EventDetailsMarshaller INSTANCE = new EventDetailsMarshaller();

    private EventDetailsMarshaller() {
    }

    public static EventDetailsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(EventDetails eventDetails, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)eventDetails, (String)"eventDetails");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)eventDetails.event(), EVENT_BINDING);
            protocolMarshaller.marshall((Object)eventDetails.eventDescription(), EVENTDESCRIPTION_BINDING);
            protocolMarshaller.marshall(eventDetails.eventMetadata(), EVENTMETADATA_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

