/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.health.model.EventDescription;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class EventDescriptionMarshaller {
    private static final MarshallingInfo<String> LATESTDESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("latestDescription").isBinary(false).build();
    private static final EventDescriptionMarshaller INSTANCE = new EventDescriptionMarshaller();

    private EventDescriptionMarshaller() {
    }

    public static EventDescriptionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(EventDescription eventDescription, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)eventDescription, (String)"eventDescription");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)eventDescription.latestDescription(), LATESTDESCRIPTION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

