/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.health.model.EntityFilter;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class EntityFilterMarshaller {
    private static final MarshallingInfo<List> EVENTARNS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("eventArns").isBinary(false).build();
    private static final MarshallingInfo<List> ENTITYARNS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("entityArns").isBinary(false).build();
    private static final MarshallingInfo<List> ENTITYVALUES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("entityValues").isBinary(false).build();
    private static final MarshallingInfo<List> LASTUPDATEDTIMES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastUpdatedTimes").isBinary(false).build();
    private static final MarshallingInfo<List> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tags").isBinary(false).build();
    private static final MarshallingInfo<List> STATUSCODES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("statusCodes").isBinary(false).build();
    private static final EntityFilterMarshaller INSTANCE = new EntityFilterMarshaller();

    private EntityFilterMarshaller() {
    }

    public static EntityFilterMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(EntityFilter entityFilter, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)entityFilter, (String)"entityFilter");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(entityFilter.eventArns(), EVENTARNS_BINDING);
            protocolMarshaller.marshall(entityFilter.entityArns(), ENTITYARNS_BINDING);
            protocolMarshaller.marshall(entityFilter.entityValues(), ENTITYVALUES_BINDING);
            protocolMarshaller.marshall(entityFilter.lastUpdatedTimes(), LASTUPDATEDTIMES_BINDING);
            protocolMarshaller.marshall(entityFilter.tags(), TAGS_BINDING);
            protocolMarshaller.marshall(entityFilter.statusCodesAsStrings(), STATUSCODES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

