/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.health.model.EntityAggregate;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class EntityAggregateMarshaller {
    private static final MarshallingInfo<String> EVENTARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("eventArn").isBinary(false).build();
    private static final MarshallingInfo<Integer> COUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("count").isBinary(false).build();
    private static final EntityAggregateMarshaller INSTANCE = new EntityAggregateMarshaller();

    private EntityAggregateMarshaller() {
    }

    public static EntityAggregateMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(EntityAggregate entityAggregate, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)entityAggregate, (String)"entityAggregate");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)entityAggregate.eventArn(), EVENTARN_BINDING);
            protocolMarshaller.marshall((Object)entityAggregate.count(), COUNT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

