/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.health.model.DateTimeRange;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DateTimeRangeMarshaller {
    private static final MarshallingInfo<Instant> FROM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("from").isBinary(false).build();
    private static final MarshallingInfo<Instant> TO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("to").isBinary(false).build();
    private static final DateTimeRangeMarshaller INSTANCE = new DateTimeRangeMarshaller();

    private DateTimeRangeMarshaller() {
    }

    public static DateTimeRangeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DateTimeRange dateTimeRange, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)dateTimeRange, (String)"dateTimeRange");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)dateTimeRange.from(), FROM_BINDING);
            protocolMarshaller.marshall((Object)dateTimeRange.to(), TO_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

