/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.transform;

import java.time.Instant;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.health.model.AffectedEntity;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AffectedEntityMarshaller {
    private static final MarshallingInfo<String> ENTITYARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("entityArn").isBinary(false).build();
    private static final MarshallingInfo<String> EVENTARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("eventArn").isBinary(false).build();
    private static final MarshallingInfo<String> ENTITYVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("entityValue").isBinary(false).build();
    private static final MarshallingInfo<String> AWSACCOUNTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("awsAccountId").isBinary(false).build();
    private static final MarshallingInfo<Instant> LASTUPDATEDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastUpdatedTime").isBinary(false).build();
    private static final MarshallingInfo<String> STATUSCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("statusCode").isBinary(false).build();
    private static final MarshallingInfo<Map> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tags").isBinary(false).build();
    private static final AffectedEntityMarshaller INSTANCE = new AffectedEntityMarshaller();

    private AffectedEntityMarshaller() {
    }

    public static AffectedEntityMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AffectedEntity affectedEntity, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)affectedEntity, (String)"affectedEntity");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)affectedEntity.entityArn(), ENTITYARN_BINDING);
            protocolMarshaller.marshall((Object)affectedEntity.eventArn(), EVENTARN_BINDING);
            protocolMarshaller.marshall((Object)affectedEntity.entityValue(), ENTITYVALUE_BINDING);
            protocolMarshaller.marshall((Object)affectedEntity.awsAccountId(), AWSACCOUNTID_BINDING);
            protocolMarshaller.marshall((Object)affectedEntity.lastUpdatedTime(), LASTUPDATEDTIME_BINDING);
            protocolMarshaller.marshall((Object)affectedEntity.statusCodeAsString(), STATUSCODE_BINDING);
            protocolMarshaller.marshall(affectedEntity.tags(), TAGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

