/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.health.HealthClient;
import software.amazon.awssdk.services.health.model.DescribeEventAggregatesRequest;
import software.amazon.awssdk.services.health.model.DescribeEventAggregatesResponse;
import software.amazon.awssdk.services.health.model.EventAggregate;

public class DescribeEventAggregatesIterable
implements SdkIterable<DescribeEventAggregatesResponse> {
    private final HealthClient client;
    private final DescribeEventAggregatesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeEventAggregatesIterable(HealthClient client, DescribeEventAggregatesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeEventAggregatesResponseFetcher();
    }

    public Iterator<DescribeEventAggregatesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<EventAggregate> eventAggregates() {
        Function<DescribeEventAggregatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.eventAggregates() != null) {
                return response.eventAggregates().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final DescribeEventAggregatesIterable resume(DescribeEventAggregatesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeEventAggregatesIterable(this.client, (DescribeEventAggregatesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeEventAggregatesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeEventAggregatesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeEventAggregatesResponseFetcher
    implements SyncPageFetcher<DescribeEventAggregatesResponse> {
        private DescribeEventAggregatesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeEventAggregatesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public DescribeEventAggregatesResponse nextPage(DescribeEventAggregatesResponse previousPage) {
            if (previousPage == null) {
                return DescribeEventAggregatesIterable.this.client.describeEventAggregates(DescribeEventAggregatesIterable.this.firstRequest);
            }
            return DescribeEventAggregatesIterable.this.client.describeEventAggregates((DescribeEventAggregatesRequest)((Object)DescribeEventAggregatesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

