/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.health.HealthAsyncClient;
import software.amazon.awssdk.services.health.model.AffectedEntity;
import software.amazon.awssdk.services.health.model.DescribeAffectedEntitiesRequest;
import software.amazon.awssdk.services.health.model.DescribeAffectedEntitiesResponse;

public class DescribeAffectedEntitiesPublisher
implements SdkPublisher<DescribeAffectedEntitiesResponse> {
    private final HealthAsyncClient client;
    private final DescribeAffectedEntitiesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeAffectedEntitiesPublisher(HealthAsyncClient client, DescribeAffectedEntitiesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeAffectedEntitiesPublisher(HealthAsyncClient client, DescribeAffectedEntitiesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeAffectedEntitiesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeAffectedEntitiesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<AffectedEntity> entities() {
        Function<DescribeAffectedEntitiesResponse, Iterator> getIterator = response -> {
            if (response != null && response.entities() != null) {
                return response.entities().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new DescribeAffectedEntitiesResponseFetcher(), getIterator, this.isLastPage);
    }

    public final DescribeAffectedEntitiesPublisher resume(DescribeAffectedEntitiesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeAffectedEntitiesPublisher(this.client, (DescribeAffectedEntitiesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeAffectedEntitiesPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeAffectedEntitiesResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeAffectedEntitiesResponseFetcher
    implements AsyncPageFetcher<DescribeAffectedEntitiesResponse> {
        private DescribeAffectedEntitiesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeAffectedEntitiesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public CompletableFuture<DescribeAffectedEntitiesResponse> nextPage(DescribeAffectedEntitiesResponse previousPage) {
            if (previousPage == null) {
                return DescribeAffectedEntitiesPublisher.this.client.describeAffectedEntities(DescribeAffectedEntitiesPublisher.this.firstRequest);
            }
            return DescribeAffectedEntitiesPublisher.this.client.describeAffectedEntities((DescribeAffectedEntitiesRequest)((Object)DescribeAffectedEntitiesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

