/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.health.HealthClient;
import software.amazon.awssdk.services.health.model.AffectedEntity;
import software.amazon.awssdk.services.health.model.DescribeAffectedEntitiesRequest;
import software.amazon.awssdk.services.health.model.DescribeAffectedEntitiesResponse;

public class DescribeAffectedEntitiesIterable
implements SdkIterable<DescribeAffectedEntitiesResponse> {
    private final HealthClient client;
    private final DescribeAffectedEntitiesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeAffectedEntitiesIterable(HealthClient client, DescribeAffectedEntitiesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeAffectedEntitiesResponseFetcher();
    }

    public Iterator<DescribeAffectedEntitiesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<AffectedEntity> entities() {
        Function<DescribeAffectedEntitiesResponse, Iterator> getIterator = response -> {
            if (response != null && response.entities() != null) {
                return response.entities().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final DescribeAffectedEntitiesIterable resume(DescribeAffectedEntitiesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeAffectedEntitiesIterable(this.client, (DescribeAffectedEntitiesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeAffectedEntitiesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeAffectedEntitiesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeAffectedEntitiesResponseFetcher
    implements SyncPageFetcher<DescribeAffectedEntitiesResponse> {
        private DescribeAffectedEntitiesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeAffectedEntitiesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public DescribeAffectedEntitiesResponse nextPage(DescribeAffectedEntitiesResponse previousPage) {
            if (previousPage == null) {
                return DescribeAffectedEntitiesIterable.this.client.describeAffectedEntities(DescribeAffectedEntitiesIterable.this.firstRequest);
            }
            return DescribeAffectedEntitiesIterable.this.client.describeAffectedEntities((DescribeAffectedEntitiesRequest)((Object)DescribeAffectedEntitiesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

