/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.health.model.EventStatusCode;
import software.amazon.awssdk.services.health.model.EventTypeCategory;
import software.amazon.awssdk.services.health.transform.EventMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Event
implements StructuredPojo,
ToCopyableBuilder<Builder, Event> {
    private final String arn;
    private final String service;
    private final String eventTypeCode;
    private final String eventTypeCategory;
    private final String region;
    private final String availabilityZone;
    private final Instant startTime;
    private final Instant endTime;
    private final Instant lastUpdatedTime;
    private final String statusCode;

    private Event(BuilderImpl builder) {
        this.arn = builder.arn;
        this.service = builder.service;
        this.eventTypeCode = builder.eventTypeCode;
        this.eventTypeCategory = builder.eventTypeCategory;
        this.region = builder.region;
        this.availabilityZone = builder.availabilityZone;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.statusCode = builder.statusCode;
    }

    public String arn() {
        return this.arn;
    }

    public String service() {
        return this.service;
    }

    public String eventTypeCode() {
        return this.eventTypeCode;
    }

    public EventTypeCategory eventTypeCategory() {
        return EventTypeCategory.fromValue(this.eventTypeCategory);
    }

    public String eventTypeCategoryAsString() {
        return this.eventTypeCategory;
    }

    public String region() {
        return this.region;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Instant endTime() {
        return this.endTime;
    }

    public Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public EventStatusCode statusCode() {
        return EventStatusCode.fromValue(this.statusCode);
    }

    public String statusCodeAsString() {
        return this.statusCode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.service());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTypeCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTypeCategoryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusCodeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Event)) {
            return false;
        }
        Event other = (Event)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.service(), other.service()) && Objects.equals(this.eventTypeCode(), other.eventTypeCode()) && Objects.equals(this.eventTypeCategoryAsString(), other.eventTypeCategoryAsString()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(this.statusCodeAsString(), other.statusCodeAsString());
    }

    public String toString() {
        return ToString.builder((String)"Event").add("Arn", (Object)this.arn()).add("Service", (Object)this.service()).add("EventTypeCode", (Object)this.eventTypeCode()).add("EventTypeCategory", (Object)this.eventTypeCategoryAsString()).add("Region", (Object)this.region()).add("AvailabilityZone", (Object)this.availabilityZone()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("StatusCode", (Object)this.statusCodeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.of(clazz.cast(this.arn()));
            }
            case "service": {
                return Optional.of(clazz.cast(this.service()));
            }
            case "eventTypeCode": {
                return Optional.of(clazz.cast(this.eventTypeCode()));
            }
            case "eventTypeCategory": {
                return Optional.of(clazz.cast(this.eventTypeCategoryAsString()));
            }
            case "region": {
                return Optional.of(clazz.cast(this.region()));
            }
            case "availabilityZone": {
                return Optional.of(clazz.cast(this.availabilityZone()));
            }
            case "startTime": {
                return Optional.of(clazz.cast(this.startTime()));
            }
            case "endTime": {
                return Optional.of(clazz.cast(this.endTime()));
            }
            case "lastUpdatedTime": {
                return Optional.of(clazz.cast(this.lastUpdatedTime()));
            }
            case "statusCode": {
                return Optional.of(clazz.cast(this.statusCodeAsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EventMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String service;
        private String eventTypeCode;
        private String eventTypeCategory;
        private String region;
        private String availabilityZone;
        private Instant startTime;
        private Instant endTime;
        private Instant lastUpdatedTime;
        private String statusCode;

        private BuilderImpl() {
        }

        private BuilderImpl(Event model) {
            this.arn(model.arn);
            this.service(model.service);
            this.eventTypeCode(model.eventTypeCode);
            this.eventTypeCategory(model.eventTypeCategory);
            this.region(model.region);
            this.availabilityZone(model.availabilityZone);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.statusCode(model.statusCode);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getService() {
            return this.service;
        }

        @Override
        public final Builder service(String service) {
            this.service = service;
            return this;
        }

        public final void setService(String service) {
            this.service = service;
        }

        public final String getEventTypeCode() {
            return this.eventTypeCode;
        }

        @Override
        public final Builder eventTypeCode(String eventTypeCode) {
            this.eventTypeCode = eventTypeCode;
            return this;
        }

        public final void setEventTypeCode(String eventTypeCode) {
            this.eventTypeCode = eventTypeCode;
        }

        public final String getEventTypeCategory() {
            return this.eventTypeCategory;
        }

        @Override
        public final Builder eventTypeCategory(String eventTypeCategory) {
            this.eventTypeCategory = eventTypeCategory;
            return this;
        }

        @Override
        public final Builder eventTypeCategory(EventTypeCategory eventTypeCategory) {
            this.eventTypeCategory(eventTypeCategory.toString());
            return this;
        }

        public final void setEventTypeCategory(String eventTypeCategory) {
            this.eventTypeCategory = eventTypeCategory;
        }

        public final String getRegion() {
            return this.region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        public final String getStatusCode() {
            return this.statusCode;
        }

        @Override
        public final Builder statusCode(String statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public final Builder statusCode(EventStatusCode statusCode) {
            this.statusCode(statusCode.toString());
            return this;
        }

        public final void setStatusCode(String statusCode) {
            this.statusCode = statusCode;
        }

        public Event build() {
            return new Event(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Event> {
        public Builder arn(String var1);

        public Builder service(String var1);

        public Builder eventTypeCode(String var1);

        public Builder eventTypeCategory(String var1);

        public Builder eventTypeCategory(EventTypeCategory var1);

        public Builder region(String var1);

        public Builder availabilityZone(String var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder lastUpdatedTime(Instant var1);

        public Builder statusCode(String var1);

        public Builder statusCode(EventStatusCode var1);
    }
}

