/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.health.model.HealthRequest;
import software.amazon.awssdk.services.health.model._eventArnListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeEventDetailsRequest
extends HealthRequest
implements ToCopyableBuilder<Builder, DescribeEventDetailsRequest> {
    private final List<String> eventArns;
    private final String locale;

    private DescribeEventDetailsRequest(BuilderImpl builder) {
        super(builder);
        this.eventArns = builder.eventArns;
        this.locale = builder.locale;
    }

    public List<String> eventArns() {
        return this.eventArns;
    }

    public String locale() {
        return this.locale;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eventArns());
        hashCode = 31 * hashCode + Objects.hashCode(this.locale());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEventDetailsRequest)) {
            return false;
        }
        DescribeEventDetailsRequest other = (DescribeEventDetailsRequest)((Object)obj);
        return Objects.equals(this.eventArns(), other.eventArns()) && Objects.equals(this.locale(), other.locale());
    }

    public String toString() {
        return ToString.builder((String)"DescribeEventDetailsRequest").add("EventArns", this.eventArns()).add("Locale", (Object)this.locale()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "eventArns": {
                return Optional.of(clazz.cast(this.eventArns()));
            }
            case "locale": {
                return Optional.of(clazz.cast(this.locale()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends HealthRequest.BuilderImpl
    implements Builder {
        private List<String> eventArns;
        private String locale;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEventDetailsRequest model) {
            super(model);
            this.eventArns(model.eventArns);
            this.locale(model.locale);
        }

        public final Collection<String> getEventArns() {
            return this.eventArns;
        }

        @Override
        public final Builder eventArns(Collection<String> eventArns) {
            this.eventArns = _eventArnListCopier.copy(eventArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventArns(String ... eventArns) {
            this.eventArns(Arrays.asList(eventArns));
            return this;
        }

        public final void setEventArns(Collection<String> eventArns) {
            this.eventArns = _eventArnListCopier.copy(eventArns);
        }

        public final String getLocale() {
            return this.locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeEventDetailsRequest build() {
            return new DescribeEventDetailsRequest(this);
        }
    }

    public static interface Builder
    extends HealthRequest.Builder,
    CopyableBuilder<Builder, DescribeEventDetailsRequest> {
        public Builder eventArns(Collection<String> var1);

        public Builder eventArns(String ... var1);

        public Builder locale(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

