/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.health.model.EventAggregateField;
import software.amazon.awssdk.services.health.model.EventFilter;
import software.amazon.awssdk.services.health.model.HealthRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeEventAggregatesRequest
extends HealthRequest
implements ToCopyableBuilder<Builder, DescribeEventAggregatesRequest> {
    private final EventFilter filter;
    private final String aggregateField;
    private final Integer maxResults;
    private final String nextToken;

    private DescribeEventAggregatesRequest(BuilderImpl builder) {
        super(builder);
        this.filter = builder.filter;
        this.aggregateField = builder.aggregateField;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public EventFilter filter() {
        return this.filter;
    }

    public EventAggregateField aggregateField() {
        return EventAggregateField.fromValue(this.aggregateField);
    }

    public String aggregateFieldAsString() {
        return this.aggregateField;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.filter());
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregateFieldAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEventAggregatesRequest)) {
            return false;
        }
        DescribeEventAggregatesRequest other = (DescribeEventAggregatesRequest)((Object)obj);
        return Objects.equals(this.filter(), other.filter()) && Objects.equals(this.aggregateFieldAsString(), other.aggregateFieldAsString()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeEventAggregatesRequest").add("Filter", (Object)this.filter()).add("AggregateField", (Object)this.aggregateFieldAsString()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "filter": {
                return Optional.of(clazz.cast(this.filter()));
            }
            case "aggregateField": {
                return Optional.of(clazz.cast(this.aggregateFieldAsString()));
            }
            case "maxResults": {
                return Optional.of(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends HealthRequest.BuilderImpl
    implements Builder {
        private EventFilter filter;
        private String aggregateField;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEventAggregatesRequest model) {
            super(model);
            this.filter(model.filter);
            this.aggregateField(model.aggregateField);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final EventFilter.Builder getFilter() {
            return this.filter != null ? this.filter.toBuilder() : null;
        }

        @Override
        public final Builder filter(EventFilter filter) {
            this.filter = filter;
            return this;
        }

        public final void setFilter(EventFilter.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        public final String getAggregateField() {
            return this.aggregateField;
        }

        @Override
        public final Builder aggregateField(String aggregateField) {
            this.aggregateField = aggregateField;
            return this;
        }

        @Override
        public final Builder aggregateField(EventAggregateField aggregateField) {
            this.aggregateField(aggregateField.toString());
            return this;
        }

        public final void setAggregateField(String aggregateField) {
            this.aggregateField = aggregateField;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeEventAggregatesRequest build() {
            return new DescribeEventAggregatesRequest(this);
        }
    }

    public static interface Builder
    extends HealthRequest.Builder,
    CopyableBuilder<Builder, DescribeEventAggregatesRequest> {
        public Builder filter(EventFilter var1);

        default public Builder filter(Consumer<EventFilter.Builder> filter) {
            return this.filter((EventFilter)((EventFilter.Builder)EventFilter.builder().apply(filter)).build());
        }

        public Builder aggregateField(String var1);

        public Builder aggregateField(EventAggregateField var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

