/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.health.transform.DateTimeRangeMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DateTimeRange
implements StructuredPojo,
ToCopyableBuilder<Builder, DateTimeRange> {
    private final Instant from;
    private final Instant to;

    private DateTimeRange(BuilderImpl builder) {
        this.from = builder.from;
        this.to = builder.to;
    }

    public Instant from() {
        return this.from;
    }

    public Instant to() {
        return this.to;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.from());
        hashCode = 31 * hashCode + Objects.hashCode(this.to());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DateTimeRange)) {
            return false;
        }
        DateTimeRange other = (DateTimeRange)obj;
        return Objects.equals(this.from(), other.from()) && Objects.equals(this.to(), other.to());
    }

    public String toString() {
        return ToString.builder((String)"DateTimeRange").add("From", (Object)this.from()).add("To", (Object)this.to()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "from": {
                return Optional.of(clazz.cast(this.from()));
            }
            case "to": {
                return Optional.of(clazz.cast(this.to()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DateTimeRangeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant from;
        private Instant to;

        private BuilderImpl() {
        }

        private BuilderImpl(DateTimeRange model) {
            this.from(model.from);
            this.to(model.to);
        }

        public final Instant getFrom() {
            return this.from;
        }

        @Override
        public final Builder from(Instant from) {
            this.from = from;
            return this;
        }

        public final void setFrom(Instant from) {
            this.from = from;
        }

        public final Instant getTo() {
            return this.to;
        }

        @Override
        public final Builder to(Instant to) {
            this.to = to;
            return this;
        }

        public final void setTo(Instant to) {
            this.to = to;
        }

        public DateTimeRange build() {
            return new DateTimeRange(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DateTimeRange> {
        public Builder from(Instant var1);

        public Builder to(Instant var1);
    }
}

