/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.config.AwsSyncClientConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocol;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.ClientExecutionParams;
import software.amazon.awssdk.core.client.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.core.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.core.runtime.http.response.JsonResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.health.HealthClient;
import software.amazon.awssdk.services.health.model.DescribeAffectedEntitiesRequest;
import software.amazon.awssdk.services.health.model.DescribeAffectedEntitiesResponse;
import software.amazon.awssdk.services.health.model.DescribeEntityAggregatesRequest;
import software.amazon.awssdk.services.health.model.DescribeEntityAggregatesResponse;
import software.amazon.awssdk.services.health.model.DescribeEventAggregatesRequest;
import software.amazon.awssdk.services.health.model.DescribeEventAggregatesResponse;
import software.amazon.awssdk.services.health.model.DescribeEventDetailsRequest;
import software.amazon.awssdk.services.health.model.DescribeEventDetailsResponse;
import software.amazon.awssdk.services.health.model.DescribeEventTypesRequest;
import software.amazon.awssdk.services.health.model.DescribeEventTypesResponse;
import software.amazon.awssdk.services.health.model.DescribeEventsRequest;
import software.amazon.awssdk.services.health.model.DescribeEventsResponse;
import software.amazon.awssdk.services.health.model.HealthException;
import software.amazon.awssdk.services.health.model.InvalidPaginationTokenException;
import software.amazon.awssdk.services.health.model.UnsupportedLocaleException;
import software.amazon.awssdk.services.health.paginators.DescribeAffectedEntitiesIterable;
import software.amazon.awssdk.services.health.paginators.DescribeEventAggregatesIterable;
import software.amazon.awssdk.services.health.paginators.DescribeEventTypesIterable;
import software.amazon.awssdk.services.health.paginators.DescribeEventsIterable;
import software.amazon.awssdk.services.health.transform.DescribeAffectedEntitiesRequestMarshaller;
import software.amazon.awssdk.services.health.transform.DescribeAffectedEntitiesResponseUnmarshaller;
import software.amazon.awssdk.services.health.transform.DescribeEntityAggregatesRequestMarshaller;
import software.amazon.awssdk.services.health.transform.DescribeEntityAggregatesResponseUnmarshaller;
import software.amazon.awssdk.services.health.transform.DescribeEventAggregatesRequestMarshaller;
import software.amazon.awssdk.services.health.transform.DescribeEventAggregatesResponseUnmarshaller;
import software.amazon.awssdk.services.health.transform.DescribeEventDetailsRequestMarshaller;
import software.amazon.awssdk.services.health.transform.DescribeEventDetailsResponseUnmarshaller;
import software.amazon.awssdk.services.health.transform.DescribeEventTypesRequestMarshaller;
import software.amazon.awssdk.services.health.transform.DescribeEventTypesResponseUnmarshaller;
import software.amazon.awssdk.services.health.transform.DescribeEventsRequestMarshaller;
import software.amazon.awssdk.services.health.transform.DescribeEventsResponseUnmarshaller;

@SdkInternalApi
final class DefaultHealthClient
implements HealthClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final AwsSyncClientConfiguration clientConfiguration;

    protected DefaultHealthClient(AwsSyncClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration, null);
        this.protocolFactory = this.init();
        this.clientConfiguration = clientConfiguration;
    }

    public final String serviceName() {
        return "health";
    }

    @Override
    public DescribeAffectedEntitiesResponse describeAffectedEntities(DescribeAffectedEntitiesRequest describeAffectedEntitiesRequest) throws InvalidPaginationTokenException, UnsupportedLocaleException, AwsServiceException, SdkClientException, HealthException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeAffectedEntitiesResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeAffectedEntitiesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAffectedEntitiesRequest).withMarshaller((Marshaller)new DescribeAffectedEntitiesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeAffectedEntitiesIterable describeAffectedEntitiesPaginator(DescribeAffectedEntitiesRequest describeAffectedEntitiesRequest) throws InvalidPaginationTokenException, UnsupportedLocaleException, AwsServiceException, SdkClientException, HealthException {
        return new DescribeAffectedEntitiesIterable(this, describeAffectedEntitiesRequest);
    }

    @Override
    public DescribeEntityAggregatesResponse describeEntityAggregates(DescribeEntityAggregatesRequest describeEntityAggregatesRequest) throws AwsServiceException, SdkClientException, HealthException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeEntityAggregatesResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeEntityAggregatesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEntityAggregatesRequest).withMarshaller((Marshaller)new DescribeEntityAggregatesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeEventAggregatesResponse describeEventAggregates(DescribeEventAggregatesRequest describeEventAggregatesRequest) throws InvalidPaginationTokenException, AwsServiceException, SdkClientException, HealthException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeEventAggregatesResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeEventAggregatesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEventAggregatesRequest).withMarshaller((Marshaller)new DescribeEventAggregatesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeEventAggregatesIterable describeEventAggregatesPaginator(DescribeEventAggregatesRequest describeEventAggregatesRequest) throws InvalidPaginationTokenException, AwsServiceException, SdkClientException, HealthException {
        return new DescribeEventAggregatesIterable(this, describeEventAggregatesRequest);
    }

    @Override
    public DescribeEventDetailsResponse describeEventDetails(DescribeEventDetailsRequest describeEventDetailsRequest) throws UnsupportedLocaleException, AwsServiceException, SdkClientException, HealthException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeEventDetailsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeEventDetailsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEventDetailsRequest).withMarshaller((Marshaller)new DescribeEventDetailsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeEventTypesResponse describeEventTypes(DescribeEventTypesRequest describeEventTypesRequest) throws InvalidPaginationTokenException, UnsupportedLocaleException, AwsServiceException, SdkClientException, HealthException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeEventTypesResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeEventTypesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEventTypesRequest).withMarshaller((Marshaller)new DescribeEventTypesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeEventTypesIterable describeEventTypesPaginator(DescribeEventTypesRequest describeEventTypesRequest) throws InvalidPaginationTokenException, UnsupportedLocaleException, AwsServiceException, SdkClientException, HealthException {
        return new DescribeEventTypesIterable(this, describeEventTypesRequest);
    }

    @Override
    public DescribeEventsResponse describeEvents(DescribeEventsRequest describeEventsRequest) throws InvalidPaginationTokenException, UnsupportedLocaleException, AwsServiceException, SdkClientException, HealthException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeEventsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeEventsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEventsRequest).withMarshaller((Marshaller)new DescribeEventsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeEventsIterable describeEventsPaginator(DescribeEventsRequest describeEventsRequest) throws InvalidPaginationTokenException, UnsupportedLocaleException, AwsServiceException, SdkClientException, HealthException {
        return new DescribeEventsIterable(this, describeEventsRequest);
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler() {
        return this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }

    private AwsJsonProtocolFactory init() {
        return new AwsJsonProtocolFactory(new JsonClientMetadata().withSupportsCbor(false).withSupportsIon(false).withBaseServiceExceptionClass(HealthException.class).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnsupportedLocale").withModeledClass(UnsupportedLocaleException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidPaginationToken").withModeledClass(InvalidPaginationTokenException.class)), AwsJsonProtocolMetadata.builder().protocolVersion("1.1").protocol(AwsJsonProtocol.AWS_JSON).build());
    }

    public void close() {
        this.clientHandler.close();
    }
}

