/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health;

import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.config.AwsAsyncClientConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocol;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.AsyncClientHandler;
import software.amazon.awssdk.core.client.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.core.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.core.runtime.http.response.JsonResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.health.HealthAsyncClient;
import software.amazon.awssdk.services.health.model.DescribeAffectedEntitiesRequest;
import software.amazon.awssdk.services.health.model.DescribeAffectedEntitiesResponse;
import software.amazon.awssdk.services.health.model.DescribeEntityAggregatesRequest;
import software.amazon.awssdk.services.health.model.DescribeEntityAggregatesResponse;
import software.amazon.awssdk.services.health.model.DescribeEventAggregatesRequest;
import software.amazon.awssdk.services.health.model.DescribeEventAggregatesResponse;
import software.amazon.awssdk.services.health.model.DescribeEventDetailsRequest;
import software.amazon.awssdk.services.health.model.DescribeEventDetailsResponse;
import software.amazon.awssdk.services.health.model.DescribeEventTypesRequest;
import software.amazon.awssdk.services.health.model.DescribeEventTypesResponse;
import software.amazon.awssdk.services.health.model.DescribeEventsRequest;
import software.amazon.awssdk.services.health.model.DescribeEventsResponse;
import software.amazon.awssdk.services.health.model.HealthException;
import software.amazon.awssdk.services.health.model.InvalidPaginationTokenException;
import software.amazon.awssdk.services.health.model.UnsupportedLocaleException;
import software.amazon.awssdk.services.health.paginators.DescribeAffectedEntitiesPublisher;
import software.amazon.awssdk.services.health.paginators.DescribeEventAggregatesPublisher;
import software.amazon.awssdk.services.health.paginators.DescribeEventTypesPublisher;
import software.amazon.awssdk.services.health.paginators.DescribeEventsPublisher;
import software.amazon.awssdk.services.health.transform.DescribeAffectedEntitiesRequestMarshaller;
import software.amazon.awssdk.services.health.transform.DescribeAffectedEntitiesResponseUnmarshaller;
import software.amazon.awssdk.services.health.transform.DescribeEntityAggregatesRequestMarshaller;
import software.amazon.awssdk.services.health.transform.DescribeEntityAggregatesResponseUnmarshaller;
import software.amazon.awssdk.services.health.transform.DescribeEventAggregatesRequestMarshaller;
import software.amazon.awssdk.services.health.transform.DescribeEventAggregatesResponseUnmarshaller;
import software.amazon.awssdk.services.health.transform.DescribeEventDetailsRequestMarshaller;
import software.amazon.awssdk.services.health.transform.DescribeEventDetailsResponseUnmarshaller;
import software.amazon.awssdk.services.health.transform.DescribeEventTypesRequestMarshaller;
import software.amazon.awssdk.services.health.transform.DescribeEventTypesResponseUnmarshaller;
import software.amazon.awssdk.services.health.transform.DescribeEventsRequestMarshaller;
import software.amazon.awssdk.services.health.transform.DescribeEventsResponseUnmarshaller;

@SdkInternalApi
final class DefaultHealthAsyncClient
implements HealthAsyncClient {
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;

    protected DefaultHealthAsyncClient(AwsAsyncClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration, null);
        this.protocolFactory = this.init();
    }

    public final String serviceName() {
        return "health";
    }

    @Override
    public CompletableFuture<DescribeAffectedEntitiesResponse> describeAffectedEntities(DescribeAffectedEntitiesRequest describeAffectedEntitiesRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeAffectedEntitiesResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeAffectedEntitiesRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAffectedEntitiesRequest));
    }

    @Override
    public DescribeAffectedEntitiesPublisher describeAffectedEntitiesPaginator(DescribeAffectedEntitiesRequest describeAffectedEntitiesRequest) {
        return new DescribeAffectedEntitiesPublisher(this, describeAffectedEntitiesRequest);
    }

    @Override
    public CompletableFuture<DescribeEntityAggregatesResponse> describeEntityAggregates(DescribeEntityAggregatesRequest describeEntityAggregatesRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeEntityAggregatesResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeEntityAggregatesRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEntityAggregatesRequest));
    }

    @Override
    public CompletableFuture<DescribeEventAggregatesResponse> describeEventAggregates(DescribeEventAggregatesRequest describeEventAggregatesRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeEventAggregatesResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeEventAggregatesRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEventAggregatesRequest));
    }

    @Override
    public DescribeEventAggregatesPublisher describeEventAggregatesPaginator(DescribeEventAggregatesRequest describeEventAggregatesRequest) {
        return new DescribeEventAggregatesPublisher(this, describeEventAggregatesRequest);
    }

    @Override
    public CompletableFuture<DescribeEventDetailsResponse> describeEventDetails(DescribeEventDetailsRequest describeEventDetailsRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeEventDetailsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeEventDetailsRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEventDetailsRequest));
    }

    @Override
    public CompletableFuture<DescribeEventTypesResponse> describeEventTypes(DescribeEventTypesRequest describeEventTypesRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeEventTypesResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeEventTypesRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEventTypesRequest));
    }

    @Override
    public DescribeEventTypesPublisher describeEventTypesPaginator(DescribeEventTypesRequest describeEventTypesRequest) {
        return new DescribeEventTypesPublisher(this, describeEventTypesRequest);
    }

    @Override
    public CompletableFuture<DescribeEventsResponse> describeEvents(DescribeEventsRequest describeEventsRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeEventsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeEventsRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEventsRequest));
    }

    @Override
    public DescribeEventsPublisher describeEventsPaginator(DescribeEventsRequest describeEventsRequest) {
        return new DescribeEventsPublisher(this, describeEventsRequest);
    }

    public void close() {
        this.clientHandler.close();
    }

    private AwsJsonProtocolFactory init() {
        return new AwsJsonProtocolFactory(new JsonClientMetadata().withSupportsCbor(false).withSupportsIon(false).withBaseServiceExceptionClass(HealthException.class).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnsupportedLocale").withModeledClass(UnsupportedLocaleException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidPaginationToken").withModeledClass(InvalidPaginationTokenException.class)), AwsJsonProtocolMetadata.builder().protocolVersion("1.1").protocol(AwsJsonProtocol.AWS_JSON).build());
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler() {
        return this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }
}

