/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.guardduty.model.ThreatIntelligenceDetail;
import software.amazon.awssdk.services.guardduty.model.ThreatIntelligenceDetailsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Evidence
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Evidence> {
    private static final SdkField<List<ThreatIntelligenceDetail>> THREAT_INTELLIGENCE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Evidence.getter(Evidence::threatIntelligenceDetails)).setter(Evidence.setter(Builder::threatIntelligenceDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("threatIntelligenceDetails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ThreatIntelligenceDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THREAT_INTELLIGENCE_DETAILS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<ThreatIntelligenceDetail> threatIntelligenceDetails;

    private Evidence(BuilderImpl builder) {
        this.threatIntelligenceDetails = builder.threatIntelligenceDetails;
    }

    public List<ThreatIntelligenceDetail> threatIntelligenceDetails() {
        return this.threatIntelligenceDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.threatIntelligenceDetails());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Evidence)) {
            return false;
        }
        Evidence other = (Evidence)obj;
        return Objects.equals(this.threatIntelligenceDetails(), other.threatIntelligenceDetails());
    }

    public String toString() {
        return ToString.builder((String)"Evidence").add("ThreatIntelligenceDetails", this.threatIntelligenceDetails()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ThreatIntelligenceDetails": {
                return Optional.ofNullable(clazz.cast(this.threatIntelligenceDetails()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Evidence, T> g) {
        return obj -> g.apply((Evidence)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ThreatIntelligenceDetail> threatIntelligenceDetails = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Evidence model) {
            this.threatIntelligenceDetails(model.threatIntelligenceDetails);
        }

        public final Collection<ThreatIntelligenceDetail.Builder> getThreatIntelligenceDetails() {
            return this.threatIntelligenceDetails != null ? (Collection)this.threatIntelligenceDetails.stream().map(ThreatIntelligenceDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder threatIntelligenceDetails(Collection<ThreatIntelligenceDetail> threatIntelligenceDetails) {
            this.threatIntelligenceDetails = ThreatIntelligenceDetailsCopier.copy(threatIntelligenceDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder threatIntelligenceDetails(ThreatIntelligenceDetail ... threatIntelligenceDetails) {
            this.threatIntelligenceDetails(Arrays.asList(threatIntelligenceDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder threatIntelligenceDetails(Consumer<ThreatIntelligenceDetail.Builder> ... threatIntelligenceDetails) {
            this.threatIntelligenceDetails(Stream.of(threatIntelligenceDetails).map(c -> (ThreatIntelligenceDetail)((ThreatIntelligenceDetail.Builder)ThreatIntelligenceDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setThreatIntelligenceDetails(Collection<ThreatIntelligenceDetail.BuilderImpl> threatIntelligenceDetails) {
            this.threatIntelligenceDetails = ThreatIntelligenceDetailsCopier.copyFromBuilder(threatIntelligenceDetails);
        }

        public Evidence build() {
            return new Evidence(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Evidence> {
        public Builder threatIntelligenceDetails(Collection<ThreatIntelligenceDetail> var1);

        public Builder threatIntelligenceDetails(ThreatIntelligenceDetail ... var1);

        public Builder threatIntelligenceDetails(Consumer<ThreatIntelligenceDetail.Builder> ... var1);
    }
}

