/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.guardduty.model.Feedback;
import software.amazon.awssdk.services.guardduty.model.FindingIdsCopier;
import software.amazon.awssdk.services.guardduty.model.GuardDutyRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateFindingsFeedbackRequest
extends GuardDutyRequest
implements ToCopyableBuilder<Builder, UpdateFindingsFeedbackRequest> {
    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateFindingsFeedbackRequest.getter(UpdateFindingsFeedbackRequest::detectorId)).setter(UpdateFindingsFeedbackRequest.setter(Builder::detectorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("detectorId").build()}).build();
    private static final SdkField<List<String>> FINDING_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(UpdateFindingsFeedbackRequest.getter(UpdateFindingsFeedbackRequest::findingIds)).setter(UpdateFindingsFeedbackRequest.setter(Builder::findingIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> FEEDBACK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateFindingsFeedbackRequest.getter(UpdateFindingsFeedbackRequest::feedbackAsString)).setter(UpdateFindingsFeedbackRequest.setter(Builder::feedback)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("feedback").build()}).build();
    private static final SdkField<String> COMMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateFindingsFeedbackRequest.getter(UpdateFindingsFeedbackRequest::comments)).setter(UpdateFindingsFeedbackRequest.setter(Builder::comments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comments").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_ID_FIELD, FINDING_IDS_FIELD, FEEDBACK_FIELD, COMMENTS_FIELD));
    private final String detectorId;
    private final List<String> findingIds;
    private final String feedback;
    private final String comments;

    private UpdateFindingsFeedbackRequest(BuilderImpl builder) {
        super(builder);
        this.detectorId = builder.detectorId;
        this.findingIds = builder.findingIds;
        this.feedback = builder.feedback;
        this.comments = builder.comments;
    }

    public String detectorId() {
        return this.detectorId;
    }

    public List<String> findingIds() {
        return this.findingIds;
    }

    public Feedback feedback() {
        return Feedback.fromValue(this.feedback);
    }

    public String feedbackAsString() {
        return this.feedback;
    }

    public String comments() {
        return this.comments;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.findingIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.feedbackAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.comments());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFindingsFeedbackRequest)) {
            return false;
        }
        UpdateFindingsFeedbackRequest other = (UpdateFindingsFeedbackRequest)((Object)obj);
        return Objects.equals(this.detectorId(), other.detectorId()) && Objects.equals(this.findingIds(), other.findingIds()) && Objects.equals(this.feedbackAsString(), other.feedbackAsString()) && Objects.equals(this.comments(), other.comments());
    }

    public String toString() {
        return ToString.builder((String)"UpdateFindingsFeedbackRequest").add("DetectorId", (Object)this.detectorId()).add("FindingIds", this.findingIds()).add("Feedback", (Object)this.feedbackAsString()).add("Comments", (Object)this.comments()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DetectorId": {
                return Optional.ofNullable(clazz.cast(this.detectorId()));
            }
            case "FindingIds": {
                return Optional.ofNullable(clazz.cast(this.findingIds()));
            }
            case "Feedback": {
                return Optional.ofNullable(clazz.cast(this.feedbackAsString()));
            }
            case "Comments": {
                return Optional.ofNullable(clazz.cast(this.comments()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFindingsFeedbackRequest, T> g) {
        return obj -> g.apply((UpdateFindingsFeedbackRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GuardDutyRequest.BuilderImpl
    implements Builder {
        private String detectorId;
        private List<String> findingIds = DefaultSdkAutoConstructList.getInstance();
        private String feedback;
        private String comments;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFindingsFeedbackRequest model) {
            super(model);
            this.detectorId(model.detectorId);
            this.findingIds(model.findingIds);
            this.feedback(model.feedback);
            this.comments(model.comments);
        }

        public final String getDetectorId() {
            return this.detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        public final Collection<String> getFindingIds() {
            return this.findingIds;
        }

        @Override
        public final Builder findingIds(Collection<String> findingIds) {
            this.findingIds = FindingIdsCopier.copy(findingIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingIds(String ... findingIds) {
            this.findingIds(Arrays.asList(findingIds));
            return this;
        }

        public final void setFindingIds(Collection<String> findingIds) {
            this.findingIds = FindingIdsCopier.copy(findingIds);
        }

        public final String getFeedbackAsString() {
            return this.feedback;
        }

        @Override
        public final Builder feedback(String feedback) {
            this.feedback = feedback;
            return this;
        }

        @Override
        public final Builder feedback(Feedback feedback) {
            this.feedback(feedback.toString());
            return this;
        }

        public final void setFeedback(String feedback) {
            this.feedback = feedback;
        }

        public final String getComments() {
            return this.comments;
        }

        @Override
        public final Builder comments(String comments) {
            this.comments = comments;
            return this;
        }

        public final void setComments(String comments) {
            this.comments = comments;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFindingsFeedbackRequest build() {
            return new UpdateFindingsFeedbackRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GuardDutyRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateFindingsFeedbackRequest> {
        public Builder detectorId(String var1);

        public Builder findingIds(Collection<String> var1);

        public Builder findingIds(String ... var1);

        public Builder feedback(String var1);

        public Builder feedback(Feedback var1);

        public Builder comments(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

