/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.guardduty.model.AccessKeyDetails;
import software.amazon.awssdk.services.guardduty.model.InstanceDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Resource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Resource> {
    private static final SdkField<AccessKeyDetails> ACCESS_KEY_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Resource.getter(Resource::accessKeyDetails)).setter(Resource.setter(Builder::accessKeyDetails)).constructor(AccessKeyDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessKeyDetails").build()}).build();
    private static final SdkField<InstanceDetails> INSTANCE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Resource.getter(Resource::instanceDetails)).setter(Resource.setter(Builder::instanceDetails)).constructor(InstanceDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceDetails").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Resource.getter(Resource::resourceType)).setter(Resource.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_KEY_DETAILS_FIELD, INSTANCE_DETAILS_FIELD, RESOURCE_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final AccessKeyDetails accessKeyDetails;
    private final InstanceDetails instanceDetails;
    private final String resourceType;

    private Resource(BuilderImpl builder) {
        this.accessKeyDetails = builder.accessKeyDetails;
        this.instanceDetails = builder.instanceDetails;
        this.resourceType = builder.resourceType;
    }

    public AccessKeyDetails accessKeyDetails() {
        return this.accessKeyDetails;
    }

    public InstanceDetails instanceDetails() {
        return this.instanceDetails;
    }

    public String resourceType() {
        return this.resourceType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accessKeyDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Resource)) {
            return false;
        }
        Resource other = (Resource)obj;
        return Objects.equals(this.accessKeyDetails(), other.accessKeyDetails()) && Objects.equals(this.instanceDetails(), other.instanceDetails()) && Objects.equals(this.resourceType(), other.resourceType());
    }

    public String toString() {
        return ToString.builder((String)"Resource").add("AccessKeyDetails", (Object)this.accessKeyDetails()).add("InstanceDetails", (Object)this.instanceDetails()).add("ResourceType", (Object)this.resourceType()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccessKeyDetails": {
                return Optional.ofNullable(clazz.cast(this.accessKeyDetails()));
            }
            case "InstanceDetails": {
                return Optional.ofNullable(clazz.cast(this.instanceDetails()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Resource, T> g) {
        return obj -> g.apply((Resource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AccessKeyDetails accessKeyDetails;
        private InstanceDetails instanceDetails;
        private String resourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(Resource model) {
            this.accessKeyDetails(model.accessKeyDetails);
            this.instanceDetails(model.instanceDetails);
            this.resourceType(model.resourceType);
        }

        public final AccessKeyDetails.Builder getAccessKeyDetails() {
            return this.accessKeyDetails != null ? this.accessKeyDetails.toBuilder() : null;
        }

        @Override
        public final Builder accessKeyDetails(AccessKeyDetails accessKeyDetails) {
            this.accessKeyDetails = accessKeyDetails;
            return this;
        }

        public final void setAccessKeyDetails(AccessKeyDetails.BuilderImpl accessKeyDetails) {
            this.accessKeyDetails = accessKeyDetails != null ? accessKeyDetails.build() : null;
        }

        public final InstanceDetails.Builder getInstanceDetails() {
            return this.instanceDetails != null ? this.instanceDetails.toBuilder() : null;
        }

        @Override
        public final Builder instanceDetails(InstanceDetails instanceDetails) {
            this.instanceDetails = instanceDetails;
            return this;
        }

        public final void setInstanceDetails(InstanceDetails.BuilderImpl instanceDetails) {
            this.instanceDetails = instanceDetails != null ? instanceDetails.build() : null;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public Resource build() {
            return new Resource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Resource> {
        public Builder accessKeyDetails(AccessKeyDetails var1);

        default public Builder accessKeyDetails(Consumer<AccessKeyDetails.Builder> accessKeyDetails) {
            return this.accessKeyDetails((AccessKeyDetails)((AccessKeyDetails.Builder)AccessKeyDetails.builder().applyMutation(accessKeyDetails)).build());
        }

        public Builder instanceDetails(InstanceDetails var1);

        default public Builder instanceDetails(Consumer<InstanceDetails.Builder> instanceDetails) {
            return this.instanceDetails((InstanceDetails)((InstanceDetails.Builder)InstanceDetails.builder().applyMutation(instanceDetails)).build());
        }

        public Builder resourceType(String var1);
    }
}

