/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.guardduty.GuardDutyAsyncClient;
import software.amazon.awssdk.services.guardduty.model.ListFiltersRequest;
import software.amazon.awssdk.services.guardduty.model.ListFiltersResponse;

public class ListFiltersPublisher
implements SdkPublisher<ListFiltersResponse> {
    private final GuardDutyAsyncClient client;
    private final ListFiltersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListFiltersPublisher(GuardDutyAsyncClient client, ListFiltersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListFiltersPublisher(GuardDutyAsyncClient client, ListFiltersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListFiltersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListFiltersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListFiltersResponseFetcher
    implements AsyncPageFetcher<ListFiltersResponse> {
        private ListFiltersResponseFetcher() {
        }

        public boolean hasNextPage(ListFiltersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListFiltersResponse> nextPage(ListFiltersResponse previousPage) {
            if (previousPage == null) {
                return ListFiltersPublisher.this.client.listFilters(ListFiltersPublisher.this.firstRequest);
            }
            return ListFiltersPublisher.this.client.listFilters((ListFiltersRequest)((Object)ListFiltersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

