/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.guardduty.model.EqCopier;
import software.amazon.awssdk.services.guardduty.model.NeqCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Condition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Condition> {
    private static final SdkField<List<String>> EQ_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Condition.getter(Condition::eq)).setter(Condition.setter(Builder::eq)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eq").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> GT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(Condition.getter(Condition::gt)).setter(Condition.setter(Builder::gt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gt").build()}).build();
    private static final SdkField<Integer> GTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(Condition.getter(Condition::gte)).setter(Condition.setter(Builder::gte)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gte").build()}).build();
    private static final SdkField<Integer> LT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(Condition.getter(Condition::lt)).setter(Condition.setter(Builder::lt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lt").build()}).build();
    private static final SdkField<Integer> LTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(Condition.getter(Condition::lte)).setter(Condition.setter(Builder::lte)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lte").build()}).build();
    private static final SdkField<List<String>> NEQ_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Condition.getter(Condition::neq)).setter(Condition.setter(Builder::neq)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("neq").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EQ_FIELD, GT_FIELD, GTE_FIELD, LT_FIELD, LTE_FIELD, NEQ_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> eq;
    private final Integer gt;
    private final Integer gte;
    private final Integer lt;
    private final Integer lte;
    private final List<String> neq;

    private Condition(BuilderImpl builder) {
        this.eq = builder.eq;
        this.gt = builder.gt;
        this.gte = builder.gte;
        this.lt = builder.lt;
        this.lte = builder.lte;
        this.neq = builder.neq;
    }

    public List<String> eq() {
        return this.eq;
    }

    public Integer gt() {
        return this.gt;
    }

    public Integer gte() {
        return this.gte;
    }

    public Integer lt() {
        return this.lt;
    }

    public Integer lte() {
        return this.lte;
    }

    public List<String> neq() {
        return this.neq;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eq());
        hashCode = 31 * hashCode + Objects.hashCode(this.gt());
        hashCode = 31 * hashCode + Objects.hashCode(this.gte());
        hashCode = 31 * hashCode + Objects.hashCode(this.lt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lte());
        hashCode = 31 * hashCode + Objects.hashCode(this.neq());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Condition)) {
            return false;
        }
        Condition other = (Condition)obj;
        return Objects.equals(this.eq(), other.eq()) && Objects.equals(this.gt(), other.gt()) && Objects.equals(this.gte(), other.gte()) && Objects.equals(this.lt(), other.lt()) && Objects.equals(this.lte(), other.lte()) && Objects.equals(this.neq(), other.neq());
    }

    public String toString() {
        return ToString.builder((String)"Condition").add("Eq", this.eq()).add("Gt", (Object)this.gt()).add("Gte", (Object)this.gte()).add("Lt", (Object)this.lt()).add("Lte", (Object)this.lte()).add("Neq", this.neq()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Eq": {
                return Optional.ofNullable(clazz.cast(this.eq()));
            }
            case "Gt": {
                return Optional.ofNullable(clazz.cast(this.gt()));
            }
            case "Gte": {
                return Optional.ofNullable(clazz.cast(this.gte()));
            }
            case "Lt": {
                return Optional.ofNullable(clazz.cast(this.lt()));
            }
            case "Lte": {
                return Optional.ofNullable(clazz.cast(this.lte()));
            }
            case "Neq": {
                return Optional.ofNullable(clazz.cast(this.neq()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Condition, T> g) {
        return obj -> g.apply((Condition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> eq = DefaultSdkAutoConstructList.getInstance();
        private Integer gt;
        private Integer gte;
        private Integer lt;
        private Integer lte;
        private List<String> neq = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Condition model) {
            this.eq(model.eq);
            this.gt(model.gt);
            this.gte(model.gte);
            this.lt(model.lt);
            this.lte(model.lte);
            this.neq(model.neq);
        }

        public final Collection<String> getEq() {
            return this.eq;
        }

        @Override
        public final Builder eq(Collection<String> eq) {
            this.eq = EqCopier.copy(eq);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eq(String ... eq) {
            this.eq(Arrays.asList(eq));
            return this;
        }

        public final void setEq(Collection<String> eq) {
            this.eq = EqCopier.copy(eq);
        }

        public final Integer getGt() {
            return this.gt;
        }

        @Override
        public final Builder gt(Integer gt) {
            this.gt = gt;
            return this;
        }

        public final void setGt(Integer gt) {
            this.gt = gt;
        }

        public final Integer getGte() {
            return this.gte;
        }

        @Override
        public final Builder gte(Integer gte) {
            this.gte = gte;
            return this;
        }

        public final void setGte(Integer gte) {
            this.gte = gte;
        }

        public final Integer getLt() {
            return this.lt;
        }

        @Override
        public final Builder lt(Integer lt) {
            this.lt = lt;
            return this;
        }

        public final void setLt(Integer lt) {
            this.lt = lt;
        }

        public final Integer getLte() {
            return this.lte;
        }

        @Override
        public final Builder lte(Integer lte) {
            this.lte = lte;
            return this;
        }

        public final void setLte(Integer lte) {
            this.lte = lte;
        }

        public final Collection<String> getNeq() {
            return this.neq;
        }

        @Override
        public final Builder neq(Collection<String> neq) {
            this.neq = NeqCopier.copy(neq);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder neq(String ... neq) {
            this.neq(Arrays.asList(neq));
            return this;
        }

        public final void setNeq(Collection<String> neq) {
            this.neq = NeqCopier.copy(neq);
        }

        public Condition build() {
            return new Condition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Condition> {
        public Builder eq(Collection<String> var1);

        public Builder eq(String ... var1);

        public Builder gt(Integer var1);

        public Builder gte(Integer var1);

        public Builder lt(Integer var1);

        public Builder lte(Integer var1);

        public Builder neq(Collection<String> var1);

        public Builder neq(String ... var1);
    }
}

