/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.guardduty.GuardDutyAsyncClient;
import software.amazon.awssdk.services.guardduty.model.ListThreatIntelSetsRequest;
import software.amazon.awssdk.services.guardduty.model.ListThreatIntelSetsResponse;

public class ListThreatIntelSetsPublisher
implements SdkPublisher<ListThreatIntelSetsResponse> {
    private final GuardDutyAsyncClient client;
    private final ListThreatIntelSetsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListThreatIntelSetsPublisher(GuardDutyAsyncClient client, ListThreatIntelSetsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListThreatIntelSetsPublisher(GuardDutyAsyncClient client, ListThreatIntelSetsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListThreatIntelSetsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListThreatIntelSetsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> threatIntelSetIds() {
        Function<ListThreatIntelSetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.threatIntelSetIds() != null) {
                return response.threatIntelSetIds().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListThreatIntelSetsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final ListThreatIntelSetsPublisher resume(ListThreatIntelSetsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListThreatIntelSetsPublisher(this.client, (ListThreatIntelSetsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListThreatIntelSetsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListThreatIntelSetsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListThreatIntelSetsResponseFetcher
    implements AsyncPageFetcher<ListThreatIntelSetsResponse> {
        private ListThreatIntelSetsResponseFetcher() {
        }

        public boolean hasNextPage(ListThreatIntelSetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListThreatIntelSetsResponse> nextPage(ListThreatIntelSetsResponse previousPage) {
            if (previousPage == null) {
                return ListThreatIntelSetsPublisher.this.client.listThreatIntelSets(ListThreatIntelSetsPublisher.this.firstRequest);
            }
            return ListThreatIntelSetsPublisher.this.client.listThreatIntelSets((ListThreatIntelSetsRequest)((Object)ListThreatIntelSetsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

