/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ThreatIntelSetStatus {
    INACTIVE("INACTIVE"),
    ACTIVATING("ACTIVATING"),
    ACTIVE("ACTIVE"),
    DEACTIVATING("DEACTIVATING"),
    ERROR("ERROR"),
    DELETE_PENDING("DELETE_PENDING"),
    DELETED("DELETED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ThreatIntelSetStatus> VALUE_MAP;
    private final String value;

    private ThreatIntelSetStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ThreatIntelSetStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ThreatIntelSetStatus> knownValues() {
        EnumSet<ThreatIntelSetStatus> knownValues = EnumSet.allOf(ThreatIntelSetStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ThreatIntelSetStatus.class, ThreatIntelSetStatus::toString);
    }
}

