/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.guardduty.model.DestinationProperties;
import software.amazon.awssdk.services.guardduty.model.GuardDutyRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdatePublishingDestinationRequest
extends GuardDutyRequest
implements ToCopyableBuilder<Builder, UpdatePublishingDestinationRequest> {
    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DetectorId").getter(UpdatePublishingDestinationRequest.getter(UpdatePublishingDestinationRequest::detectorId)).setter(UpdatePublishingDestinationRequest.setter(Builder::detectorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("detectorId").build()}).build();
    private static final SdkField<String> DESTINATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationId").getter(UpdatePublishingDestinationRequest.getter(UpdatePublishingDestinationRequest::destinationId)).setter(UpdatePublishingDestinationRequest.setter(Builder::destinationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("destinationId").build()}).build();
    private static final SdkField<DestinationProperties> DESTINATION_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DestinationProperties").getter(UpdatePublishingDestinationRequest.getter(UpdatePublishingDestinationRequest::destinationProperties)).setter(UpdatePublishingDestinationRequest.setter(Builder::destinationProperties)).constructor(DestinationProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationProperties").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_ID_FIELD, DESTINATION_ID_FIELD, DESTINATION_PROPERTIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdatePublishingDestinationRequest.memberNameToFieldInitializer();
    private final String detectorId;
    private final String destinationId;
    private final DestinationProperties destinationProperties;

    private UpdatePublishingDestinationRequest(BuilderImpl builder) {
        super(builder);
        this.detectorId = builder.detectorId;
        this.destinationId = builder.destinationId;
        this.destinationProperties = builder.destinationProperties;
    }

    public final String detectorId() {
        return this.detectorId;
    }

    public final String destinationId() {
        return this.destinationId;
    }

    public final DestinationProperties destinationProperties() {
        return this.destinationProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationProperties());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePublishingDestinationRequest)) {
            return false;
        }
        UpdatePublishingDestinationRequest other = (UpdatePublishingDestinationRequest)((Object)obj);
        return Objects.equals(this.detectorId(), other.detectorId()) && Objects.equals(this.destinationId(), other.destinationId()) && Objects.equals(this.destinationProperties(), other.destinationProperties());
    }

    public final String toString() {
        return ToString.builder((String)"UpdatePublishingDestinationRequest").add("DetectorId", (Object)this.detectorId()).add("DestinationId", (Object)this.destinationId()).add("DestinationProperties", (Object)this.destinationProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DetectorId": {
                return Optional.ofNullable(clazz.cast(this.detectorId()));
            }
            case "DestinationId": {
                return Optional.ofNullable(clazz.cast(this.destinationId()));
            }
            case "DestinationProperties": {
                return Optional.ofNullable(clazz.cast(this.destinationProperties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("detectorId", DETECTOR_ID_FIELD);
        map.put("destinationId", DESTINATION_ID_FIELD);
        map.put("destinationProperties", DESTINATION_PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdatePublishingDestinationRequest, T> g) {
        return obj -> g.apply((UpdatePublishingDestinationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GuardDutyRequest.BuilderImpl
    implements Builder {
        private String detectorId;
        private String destinationId;
        private DestinationProperties destinationProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePublishingDestinationRequest model) {
            super(model);
            this.detectorId(model.detectorId);
            this.destinationId(model.destinationId);
            this.destinationProperties(model.destinationProperties);
        }

        public final String getDetectorId() {
            return this.detectorId;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final String getDestinationId() {
            return this.destinationId;
        }

        public final void setDestinationId(String destinationId) {
            this.destinationId = destinationId;
        }

        @Override
        public final Builder destinationId(String destinationId) {
            this.destinationId = destinationId;
            return this;
        }

        public final DestinationProperties.Builder getDestinationProperties() {
            return this.destinationProperties != null ? this.destinationProperties.toBuilder() : null;
        }

        public final void setDestinationProperties(DestinationProperties.BuilderImpl destinationProperties) {
            this.destinationProperties = destinationProperties != null ? destinationProperties.build() : null;
        }

        @Override
        public final Builder destinationProperties(DestinationProperties destinationProperties) {
            this.destinationProperties = destinationProperties;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePublishingDestinationRequest build() {
            return new UpdatePublishingDestinationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GuardDutyRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdatePublishingDestinationRequest> {
        public Builder detectorId(String var1);

        public Builder destinationId(String var1);

        public Builder destinationProperties(DestinationProperties var1);

        default public Builder destinationProperties(Consumer<DestinationProperties.Builder> destinationProperties) {
            return this.destinationProperties((DestinationProperties)((DestinationProperties.Builder)DestinationProperties.builder().applyMutation(destinationProperties)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

