/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.guardduty.model.Action;
import software.amazon.awssdk.services.guardduty.model.Detection;
import software.amazon.awssdk.services.guardduty.model.EbsVolumeScanDetails;
import software.amazon.awssdk.services.guardduty.model.Evidence;
import software.amazon.awssdk.services.guardduty.model.MalwareScanDetails;
import software.amazon.awssdk.services.guardduty.model.RuntimeDetails;
import software.amazon.awssdk.services.guardduty.model.ServiceAdditionalInfo;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Service
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Service> {
    private static final SdkField<Action> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Action").getter(Service.getter(Service::action)).setter(Service.setter(Builder::action)).constructor(Action::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()}).build();
    private static final SdkField<Evidence> EVIDENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Evidence").getter(Service.getter(Service::evidence)).setter(Service.setter(Builder::evidence)).constructor(Evidence::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evidence").build()}).build();
    private static final SdkField<Boolean> ARCHIVED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Archived").getter(Service.getter(Service::archived)).setter(Service.setter(Builder::archived)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("archived").build()}).build();
    private static final SdkField<Integer> COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Count").getter(Service.getter(Service::count)).setter(Service.setter(Builder::count)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("count").build()}).build();
    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DetectorId").getter(Service.getter(Service::detectorId)).setter(Service.setter(Builder::detectorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorId").build()}).build();
    private static final SdkField<String> EVENT_FIRST_SEEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventFirstSeen").getter(Service.getter(Service::eventFirstSeen)).setter(Service.setter(Builder::eventFirstSeen)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventFirstSeen").build()}).build();
    private static final SdkField<String> EVENT_LAST_SEEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventLastSeen").getter(Service.getter(Service::eventLastSeen)).setter(Service.setter(Builder::eventLastSeen)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventLastSeen").build()}).build();
    private static final SdkField<String> RESOURCE_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceRole").getter(Service.getter(Service::resourceRole)).setter(Service.setter(Builder::resourceRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceRole").build()}).build();
    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceName").getter(Service.getter(Service::serviceName)).setter(Service.setter(Builder::serviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceName").build()}).build();
    private static final SdkField<String> USER_FEEDBACK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserFeedback").getter(Service.getter(Service::userFeedback)).setter(Service.setter(Builder::userFeedback)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userFeedback").build()}).build();
    private static final SdkField<ServiceAdditionalInfo> ADDITIONAL_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AdditionalInfo").getter(Service.getter(Service::additionalInfo)).setter(Service.setter(Builder::additionalInfo)).constructor(ServiceAdditionalInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalInfo").build()}).build();
    private static final SdkField<String> FEATURE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FeatureName").getter(Service.getter(Service::featureName)).setter(Service.setter(Builder::featureName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("featureName").build()}).build();
    private static final SdkField<EbsVolumeScanDetails> EBS_VOLUME_SCAN_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EbsVolumeScanDetails").getter(Service.getter(Service::ebsVolumeScanDetails)).setter(Service.setter(Builder::ebsVolumeScanDetails)).constructor(EbsVolumeScanDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ebsVolumeScanDetails").build()}).build();
    private static final SdkField<RuntimeDetails> RUNTIME_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RuntimeDetails").getter(Service.getter(Service::runtimeDetails)).setter(Service.setter(Builder::runtimeDetails)).constructor(RuntimeDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runtimeDetails").build()}).build();
    private static final SdkField<Detection> DETECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Detection").getter(Service.getter(Service::detection)).setter(Service.setter(Builder::detection)).constructor(Detection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detection").build()}).build();
    private static final SdkField<MalwareScanDetails> MALWARE_SCAN_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MalwareScanDetails").getter(Service.getter(Service::malwareScanDetails)).setter(Service.setter(Builder::malwareScanDetails)).constructor(MalwareScanDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("malwareScanDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, EVIDENCE_FIELD, ARCHIVED_FIELD, COUNT_FIELD, DETECTOR_ID_FIELD, EVENT_FIRST_SEEN_FIELD, EVENT_LAST_SEEN_FIELD, RESOURCE_ROLE_FIELD, SERVICE_NAME_FIELD, USER_FEEDBACK_FIELD, ADDITIONAL_INFO_FIELD, FEATURE_NAME_FIELD, EBS_VOLUME_SCAN_DETAILS_FIELD, RUNTIME_DETAILS_FIELD, DETECTION_FIELD, MALWARE_SCAN_DETAILS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Service.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Action action;
    private final Evidence evidence;
    private final Boolean archived;
    private final Integer count;
    private final String detectorId;
    private final String eventFirstSeen;
    private final String eventLastSeen;
    private final String resourceRole;
    private final String serviceName;
    private final String userFeedback;
    private final ServiceAdditionalInfo additionalInfo;
    private final String featureName;
    private final EbsVolumeScanDetails ebsVolumeScanDetails;
    private final RuntimeDetails runtimeDetails;
    private final Detection detection;
    private final MalwareScanDetails malwareScanDetails;

    private Service(BuilderImpl builder) {
        this.action = builder.action;
        this.evidence = builder.evidence;
        this.archived = builder.archived;
        this.count = builder.count;
        this.detectorId = builder.detectorId;
        this.eventFirstSeen = builder.eventFirstSeen;
        this.eventLastSeen = builder.eventLastSeen;
        this.resourceRole = builder.resourceRole;
        this.serviceName = builder.serviceName;
        this.userFeedback = builder.userFeedback;
        this.additionalInfo = builder.additionalInfo;
        this.featureName = builder.featureName;
        this.ebsVolumeScanDetails = builder.ebsVolumeScanDetails;
        this.runtimeDetails = builder.runtimeDetails;
        this.detection = builder.detection;
        this.malwareScanDetails = builder.malwareScanDetails;
    }

    public final Action action() {
        return this.action;
    }

    public final Evidence evidence() {
        return this.evidence;
    }

    public final Boolean archived() {
        return this.archived;
    }

    public final Integer count() {
        return this.count;
    }

    public final String detectorId() {
        return this.detectorId;
    }

    public final String eventFirstSeen() {
        return this.eventFirstSeen;
    }

    public final String eventLastSeen() {
        return this.eventLastSeen;
    }

    public final String resourceRole() {
        return this.resourceRole;
    }

    public final String serviceName() {
        return this.serviceName;
    }

    public final String userFeedback() {
        return this.userFeedback;
    }

    public final ServiceAdditionalInfo additionalInfo() {
        return this.additionalInfo;
    }

    public final String featureName() {
        return this.featureName;
    }

    public final EbsVolumeScanDetails ebsVolumeScanDetails() {
        return this.ebsVolumeScanDetails;
    }

    public final RuntimeDetails runtimeDetails() {
        return this.runtimeDetails;
    }

    public final Detection detection() {
        return this.detection;
    }

    public final MalwareScanDetails malwareScanDetails() {
        return this.malwareScanDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.action());
        hashCode = 31 * hashCode + Objects.hashCode(this.evidence());
        hashCode = 31 * hashCode + Objects.hashCode(this.archived());
        hashCode = 31 * hashCode + Objects.hashCode(this.count());
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventFirstSeen());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventLastSeen());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.userFeedback());
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.featureName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ebsVolumeScanDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.runtimeDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.detection());
        hashCode = 31 * hashCode + Objects.hashCode(this.malwareScanDetails());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Service)) {
            return false;
        }
        Service other = (Service)obj;
        return Objects.equals(this.action(), other.action()) && Objects.equals(this.evidence(), other.evidence()) && Objects.equals(this.archived(), other.archived()) && Objects.equals(this.count(), other.count()) && Objects.equals(this.detectorId(), other.detectorId()) && Objects.equals(this.eventFirstSeen(), other.eventFirstSeen()) && Objects.equals(this.eventLastSeen(), other.eventLastSeen()) && Objects.equals(this.resourceRole(), other.resourceRole()) && Objects.equals(this.serviceName(), other.serviceName()) && Objects.equals(this.userFeedback(), other.userFeedback()) && Objects.equals(this.additionalInfo(), other.additionalInfo()) && Objects.equals(this.featureName(), other.featureName()) && Objects.equals(this.ebsVolumeScanDetails(), other.ebsVolumeScanDetails()) && Objects.equals(this.runtimeDetails(), other.runtimeDetails()) && Objects.equals(this.detection(), other.detection()) && Objects.equals(this.malwareScanDetails(), other.malwareScanDetails());
    }

    public final String toString() {
        return ToString.builder((String)"Service").add("Action", (Object)this.action()).add("Evidence", (Object)this.evidence()).add("Archived", (Object)this.archived()).add("Count", (Object)this.count()).add("DetectorId", (Object)this.detectorId()).add("EventFirstSeen", (Object)this.eventFirstSeen()).add("EventLastSeen", (Object)this.eventLastSeen()).add("ResourceRole", (Object)this.resourceRole()).add("ServiceName", (Object)this.serviceName()).add("UserFeedback", (Object)this.userFeedback()).add("AdditionalInfo", (Object)this.additionalInfo()).add("FeatureName", (Object)this.featureName()).add("EbsVolumeScanDetails", (Object)this.ebsVolumeScanDetails()).add("RuntimeDetails", (Object)this.runtimeDetails()).add("Detection", (Object)this.detection()).add("MalwareScanDetails", (Object)this.malwareScanDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.action()));
            }
            case "Evidence": {
                return Optional.ofNullable(clazz.cast(this.evidence()));
            }
            case "Archived": {
                return Optional.ofNullable(clazz.cast(this.archived()));
            }
            case "Count": {
                return Optional.ofNullable(clazz.cast(this.count()));
            }
            case "DetectorId": {
                return Optional.ofNullable(clazz.cast(this.detectorId()));
            }
            case "EventFirstSeen": {
                return Optional.ofNullable(clazz.cast(this.eventFirstSeen()));
            }
            case "EventLastSeen": {
                return Optional.ofNullable(clazz.cast(this.eventLastSeen()));
            }
            case "ResourceRole": {
                return Optional.ofNullable(clazz.cast(this.resourceRole()));
            }
            case "ServiceName": {
                return Optional.ofNullable(clazz.cast(this.serviceName()));
            }
            case "UserFeedback": {
                return Optional.ofNullable(clazz.cast(this.userFeedback()));
            }
            case "AdditionalInfo": {
                return Optional.ofNullable(clazz.cast(this.additionalInfo()));
            }
            case "FeatureName": {
                return Optional.ofNullable(clazz.cast(this.featureName()));
            }
            case "EbsVolumeScanDetails": {
                return Optional.ofNullable(clazz.cast(this.ebsVolumeScanDetails()));
            }
            case "RuntimeDetails": {
                return Optional.ofNullable(clazz.cast(this.runtimeDetails()));
            }
            case "Detection": {
                return Optional.ofNullable(clazz.cast(this.detection()));
            }
            case "MalwareScanDetails": {
                return Optional.ofNullable(clazz.cast(this.malwareScanDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("action", ACTION_FIELD);
        map.put("evidence", EVIDENCE_FIELD);
        map.put("archived", ARCHIVED_FIELD);
        map.put("count", COUNT_FIELD);
        map.put("detectorId", DETECTOR_ID_FIELD);
        map.put("eventFirstSeen", EVENT_FIRST_SEEN_FIELD);
        map.put("eventLastSeen", EVENT_LAST_SEEN_FIELD);
        map.put("resourceRole", RESOURCE_ROLE_FIELD);
        map.put("serviceName", SERVICE_NAME_FIELD);
        map.put("userFeedback", USER_FEEDBACK_FIELD);
        map.put("additionalInfo", ADDITIONAL_INFO_FIELD);
        map.put("featureName", FEATURE_NAME_FIELD);
        map.put("ebsVolumeScanDetails", EBS_VOLUME_SCAN_DETAILS_FIELD);
        map.put("runtimeDetails", RUNTIME_DETAILS_FIELD);
        map.put("detection", DETECTION_FIELD);
        map.put("malwareScanDetails", MALWARE_SCAN_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Service, T> g) {
        return obj -> g.apply((Service)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Action action;
        private Evidence evidence;
        private Boolean archived;
        private Integer count;
        private String detectorId;
        private String eventFirstSeen;
        private String eventLastSeen;
        private String resourceRole;
        private String serviceName;
        private String userFeedback;
        private ServiceAdditionalInfo additionalInfo;
        private String featureName;
        private EbsVolumeScanDetails ebsVolumeScanDetails;
        private RuntimeDetails runtimeDetails;
        private Detection detection;
        private MalwareScanDetails malwareScanDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(Service model) {
            this.action(model.action);
            this.evidence(model.evidence);
            this.archived(model.archived);
            this.count(model.count);
            this.detectorId(model.detectorId);
            this.eventFirstSeen(model.eventFirstSeen);
            this.eventLastSeen(model.eventLastSeen);
            this.resourceRole(model.resourceRole);
            this.serviceName(model.serviceName);
            this.userFeedback(model.userFeedback);
            this.additionalInfo(model.additionalInfo);
            this.featureName(model.featureName);
            this.ebsVolumeScanDetails(model.ebsVolumeScanDetails);
            this.runtimeDetails(model.runtimeDetails);
            this.detection(model.detection);
            this.malwareScanDetails(model.malwareScanDetails);
        }

        public final Action.Builder getAction() {
            return this.action != null ? this.action.toBuilder() : null;
        }

        public final void setAction(Action.BuilderImpl action) {
            this.action = action != null ? action.build() : null;
        }

        @Override
        public final Builder action(Action action) {
            this.action = action;
            return this;
        }

        public final Evidence.Builder getEvidence() {
            return this.evidence != null ? this.evidence.toBuilder() : null;
        }

        public final void setEvidence(Evidence.BuilderImpl evidence) {
            this.evidence = evidence != null ? evidence.build() : null;
        }

        @Override
        public final Builder evidence(Evidence evidence) {
            this.evidence = evidence;
            return this;
        }

        public final Boolean getArchived() {
            return this.archived;
        }

        public final void setArchived(Boolean archived) {
            this.archived = archived;
        }

        @Override
        public final Builder archived(Boolean archived) {
            this.archived = archived;
            return this;
        }

        public final Integer getCount() {
            return this.count;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final String getDetectorId() {
            return this.detectorId;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final String getEventFirstSeen() {
            return this.eventFirstSeen;
        }

        public final void setEventFirstSeen(String eventFirstSeen) {
            this.eventFirstSeen = eventFirstSeen;
        }

        @Override
        public final Builder eventFirstSeen(String eventFirstSeen) {
            this.eventFirstSeen = eventFirstSeen;
            return this;
        }

        public final String getEventLastSeen() {
            return this.eventLastSeen;
        }

        public final void setEventLastSeen(String eventLastSeen) {
            this.eventLastSeen = eventLastSeen;
        }

        @Override
        public final Builder eventLastSeen(String eventLastSeen) {
            this.eventLastSeen = eventLastSeen;
            return this;
        }

        public final String getResourceRole() {
            return this.resourceRole;
        }

        public final void setResourceRole(String resourceRole) {
            this.resourceRole = resourceRole;
        }

        @Override
        public final Builder resourceRole(String resourceRole) {
            this.resourceRole = resourceRole;
            return this;
        }

        public final String getServiceName() {
            return this.serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final String getUserFeedback() {
            return this.userFeedback;
        }

        public final void setUserFeedback(String userFeedback) {
            this.userFeedback = userFeedback;
        }

        @Override
        public final Builder userFeedback(String userFeedback) {
            this.userFeedback = userFeedback;
            return this;
        }

        public final ServiceAdditionalInfo.Builder getAdditionalInfo() {
            return this.additionalInfo != null ? this.additionalInfo.toBuilder() : null;
        }

        public final void setAdditionalInfo(ServiceAdditionalInfo.BuilderImpl additionalInfo) {
            this.additionalInfo = additionalInfo != null ? additionalInfo.build() : null;
        }

        @Override
        public final Builder additionalInfo(ServiceAdditionalInfo additionalInfo) {
            this.additionalInfo = additionalInfo;
            return this;
        }

        public final String getFeatureName() {
            return this.featureName;
        }

        public final void setFeatureName(String featureName) {
            this.featureName = featureName;
        }

        @Override
        public final Builder featureName(String featureName) {
            this.featureName = featureName;
            return this;
        }

        public final EbsVolumeScanDetails.Builder getEbsVolumeScanDetails() {
            return this.ebsVolumeScanDetails != null ? this.ebsVolumeScanDetails.toBuilder() : null;
        }

        public final void setEbsVolumeScanDetails(EbsVolumeScanDetails.BuilderImpl ebsVolumeScanDetails) {
            this.ebsVolumeScanDetails = ebsVolumeScanDetails != null ? ebsVolumeScanDetails.build() : null;
        }

        @Override
        public final Builder ebsVolumeScanDetails(EbsVolumeScanDetails ebsVolumeScanDetails) {
            this.ebsVolumeScanDetails = ebsVolumeScanDetails;
            return this;
        }

        public final RuntimeDetails.Builder getRuntimeDetails() {
            return this.runtimeDetails != null ? this.runtimeDetails.toBuilder() : null;
        }

        public final void setRuntimeDetails(RuntimeDetails.BuilderImpl runtimeDetails) {
            this.runtimeDetails = runtimeDetails != null ? runtimeDetails.build() : null;
        }

        @Override
        public final Builder runtimeDetails(RuntimeDetails runtimeDetails) {
            this.runtimeDetails = runtimeDetails;
            return this;
        }

        public final Detection.Builder getDetection() {
            return this.detection != null ? this.detection.toBuilder() : null;
        }

        public final void setDetection(Detection.BuilderImpl detection) {
            this.detection = detection != null ? detection.build() : null;
        }

        @Override
        public final Builder detection(Detection detection) {
            this.detection = detection;
            return this;
        }

        public final MalwareScanDetails.Builder getMalwareScanDetails() {
            return this.malwareScanDetails != null ? this.malwareScanDetails.toBuilder() : null;
        }

        public final void setMalwareScanDetails(MalwareScanDetails.BuilderImpl malwareScanDetails) {
            this.malwareScanDetails = malwareScanDetails != null ? malwareScanDetails.build() : null;
        }

        @Override
        public final Builder malwareScanDetails(MalwareScanDetails malwareScanDetails) {
            this.malwareScanDetails = malwareScanDetails;
            return this;
        }

        public Service build() {
            return new Service(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Service> {
        public Builder action(Action var1);

        default public Builder action(Consumer<Action.Builder> action) {
            return this.action((Action)((Action.Builder)Action.builder().applyMutation(action)).build());
        }

        public Builder evidence(Evidence var1);

        default public Builder evidence(Consumer<Evidence.Builder> evidence) {
            return this.evidence((Evidence)((Evidence.Builder)Evidence.builder().applyMutation(evidence)).build());
        }

        public Builder archived(Boolean var1);

        public Builder count(Integer var1);

        public Builder detectorId(String var1);

        public Builder eventFirstSeen(String var1);

        public Builder eventLastSeen(String var1);

        public Builder resourceRole(String var1);

        public Builder serviceName(String var1);

        public Builder userFeedback(String var1);

        public Builder additionalInfo(ServiceAdditionalInfo var1);

        default public Builder additionalInfo(Consumer<ServiceAdditionalInfo.Builder> additionalInfo) {
            return this.additionalInfo((ServiceAdditionalInfo)((ServiceAdditionalInfo.Builder)ServiceAdditionalInfo.builder().applyMutation(additionalInfo)).build());
        }

        public Builder featureName(String var1);

        public Builder ebsVolumeScanDetails(EbsVolumeScanDetails var1);

        default public Builder ebsVolumeScanDetails(Consumer<EbsVolumeScanDetails.Builder> ebsVolumeScanDetails) {
            return this.ebsVolumeScanDetails((EbsVolumeScanDetails)((EbsVolumeScanDetails.Builder)EbsVolumeScanDetails.builder().applyMutation(ebsVolumeScanDetails)).build());
        }

        public Builder runtimeDetails(RuntimeDetails var1);

        default public Builder runtimeDetails(Consumer<RuntimeDetails.Builder> runtimeDetails) {
            return this.runtimeDetails((RuntimeDetails)((RuntimeDetails.Builder)RuntimeDetails.builder().applyMutation(runtimeDetails)).build());
        }

        public Builder detection(Detection var1);

        default public Builder detection(Consumer<Detection.Builder> detection) {
            return this.detection((Detection)((Detection.Builder)Detection.builder().applyMutation(detection)).build());
        }

        public Builder malwareScanDetails(MalwareScanDetails var1);

        default public Builder malwareScanDetails(Consumer<MalwareScanDetails.Builder> malwareScanDetails) {
            return this.malwareScanDetails((MalwareScanDetails)((MalwareScanDetails.Builder)MalwareScanDetails.builder().applyMutation(malwareScanDetails)).build());
        }
    }
}

