/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ItemPath
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ItemPath> {
    private static final SdkField<String> NESTED_ITEM_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NestedItemPath").getter(ItemPath.getter(ItemPath::nestedItemPath)).setter(ItemPath.setter(Builder::nestedItemPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nestedItemPath").build()}).build();
    private static final SdkField<String> HASH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Hash").getter(ItemPath.getter(ItemPath::hash)).setter(ItemPath.setter(Builder::hash)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hash").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NESTED_ITEM_PATH_FIELD, HASH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ItemPath.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String nestedItemPath;
    private final String hash;

    private ItemPath(BuilderImpl builder) {
        this.nestedItemPath = builder.nestedItemPath;
        this.hash = builder.hash;
    }

    public final String nestedItemPath() {
        return this.nestedItemPath;
    }

    public final String hash() {
        return this.hash;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nestedItemPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.hash());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ItemPath)) {
            return false;
        }
        ItemPath other = (ItemPath)obj;
        return Objects.equals(this.nestedItemPath(), other.nestedItemPath()) && Objects.equals(this.hash(), other.hash());
    }

    public final String toString() {
        return ToString.builder((String)"ItemPath").add("NestedItemPath", (Object)this.nestedItemPath()).add("Hash", (Object)this.hash()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NestedItemPath": {
                return Optional.ofNullable(clazz.cast(this.nestedItemPath()));
            }
            case "Hash": {
                return Optional.ofNullable(clazz.cast(this.hash()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("nestedItemPath", NESTED_ITEM_PATH_FIELD);
        map.put("hash", HASH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ItemPath, T> g) {
        return obj -> g.apply((ItemPath)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String nestedItemPath;
        private String hash;

        private BuilderImpl() {
        }

        private BuilderImpl(ItemPath model) {
            this.nestedItemPath(model.nestedItemPath);
            this.hash(model.hash);
        }

        public final String getNestedItemPath() {
            return this.nestedItemPath;
        }

        public final void setNestedItemPath(String nestedItemPath) {
            this.nestedItemPath = nestedItemPath;
        }

        @Override
        public final Builder nestedItemPath(String nestedItemPath) {
            this.nestedItemPath = nestedItemPath;
            return this;
        }

        public final String getHash() {
            return this.hash;
        }

        public final void setHash(String hash) {
            this.hash = hash;
        }

        @Override
        public final Builder hash(String hash) {
            this.hash = hash;
            return this;
        }

        public ItemPath build() {
            return new ItemPath(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ItemPath> {
        public Builder nestedItemPath(String var1);

        public Builder hash(String var1);
    }
}

