/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.guardduty.model.ScanCondition;
import software.amazon.awssdk.services.guardduty.model.ScanCriterionCopier;
import software.amazon.awssdk.services.guardduty.model.ScanCriterionKey;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScanResourceCriteria
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ScanResourceCriteria> {
    private static final SdkField<Map<String, ScanCondition>> INCLUDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Include").getter(ScanResourceCriteria.getter(ScanResourceCriteria::includeAsStrings)).setter(ScanResourceCriteria.setter(Builder::includeWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("include").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ScanCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, ScanCondition>> EXCLUDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Exclude").getter(ScanResourceCriteria.getter(ScanResourceCriteria::excludeAsStrings)).setter(ScanResourceCriteria.setter(Builder::excludeWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exclude").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ScanCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INCLUDE_FIELD, EXCLUDE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ScanResourceCriteria.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Map<String, ScanCondition> include;
    private final Map<String, ScanCondition> exclude;

    private ScanResourceCriteria(BuilderImpl builder) {
        this.include = builder.include;
        this.exclude = builder.exclude;
    }

    public final Map<ScanCriterionKey, ScanCondition> include() {
        return ScanCriterionCopier.copyStringToEnum(this.include);
    }

    public final boolean hasInclude() {
        return this.include != null && !(this.include instanceof SdkAutoConstructMap);
    }

    public final Map<String, ScanCondition> includeAsStrings() {
        return this.include;
    }

    public final Map<ScanCriterionKey, ScanCondition> exclude() {
        return ScanCriterionCopier.copyStringToEnum(this.exclude);
    }

    public final boolean hasExclude() {
        return this.exclude != null && !(this.exclude instanceof SdkAutoConstructMap);
    }

    public final Map<String, ScanCondition> excludeAsStrings() {
        return this.exclude;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInclude() ? this.includeAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExclude() ? this.excludeAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScanResourceCriteria)) {
            return false;
        }
        ScanResourceCriteria other = (ScanResourceCriteria)obj;
        return this.hasInclude() == other.hasInclude() && Objects.equals(this.includeAsStrings(), other.includeAsStrings()) && this.hasExclude() == other.hasExclude() && Objects.equals(this.excludeAsStrings(), other.excludeAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"ScanResourceCriteria").add("Include", this.hasInclude() ? this.includeAsStrings() : null).add("Exclude", this.hasExclude() ? this.excludeAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Include": {
                return Optional.ofNullable(clazz.cast(this.includeAsStrings()));
            }
            case "Exclude": {
                return Optional.ofNullable(clazz.cast(this.excludeAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Map<String, ScanCondition>>> map = new HashMap<String, SdkField<Map<String, ScanCondition>>>();
        map.put("include", INCLUDE_FIELD);
        map.put("exclude", EXCLUDE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ScanResourceCriteria, T> g) {
        return obj -> g.apply((ScanResourceCriteria)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, ScanCondition> include = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, ScanCondition> exclude = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ScanResourceCriteria model) {
            this.includeWithStrings(model.include);
            this.excludeWithStrings(model.exclude);
        }

        public final Map<String, ScanCondition.Builder> getInclude() {
            Map<String, ScanCondition.Builder> result = ScanCriterionCopier.copyToBuilder(this.include);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setInclude(Map<String, ScanCondition.BuilderImpl> include) {
            this.include = ScanCriterionCopier.copyFromBuilder(include);
        }

        @Override
        public final Builder includeWithStrings(Map<String, ScanCondition> include) {
            this.include = ScanCriterionCopier.copy(include);
            return this;
        }

        @Override
        public final Builder include(Map<ScanCriterionKey, ScanCondition> include) {
            this.include = ScanCriterionCopier.copyEnumToString(include);
            return this;
        }

        public final Map<String, ScanCondition.Builder> getExclude() {
            Map<String, ScanCondition.Builder> result = ScanCriterionCopier.copyToBuilder(this.exclude);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setExclude(Map<String, ScanCondition.BuilderImpl> exclude) {
            this.exclude = ScanCriterionCopier.copyFromBuilder(exclude);
        }

        @Override
        public final Builder excludeWithStrings(Map<String, ScanCondition> exclude) {
            this.exclude = ScanCriterionCopier.copy(exclude);
            return this;
        }

        @Override
        public final Builder exclude(Map<ScanCriterionKey, ScanCondition> exclude) {
            this.exclude = ScanCriterionCopier.copyEnumToString(exclude);
            return this;
        }

        public ScanResourceCriteria build() {
            return new ScanResourceCriteria(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ScanResourceCriteria> {
        public Builder includeWithStrings(Map<String, ScanCondition> var1);

        public Builder include(Map<ScanCriterionKey, ScanCondition> var1);

        public Builder excludeWithStrings(Map<String, ScanCondition> var1);

        public Builder exclude(Map<ScanCriterionKey, ScanCondition> var1);
    }
}

