/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.guardduty.model.DetectorIdsCopier;
import software.amazon.awssdk.services.guardduty.model.GuardDutyResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDetectorsResponse
extends GuardDutyResponse
implements ToCopyableBuilder<Builder, ListDetectorsResponse> {
    private static final SdkField<List<String>> DETECTOR_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DetectorIds").getter(ListDetectorsResponse.getter(ListDetectorsResponse::detectorIds)).setter(ListDetectorsResponse.setter(Builder::detectorIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListDetectorsResponse.getter(ListDetectorsResponse::nextToken)).setter(ListDetectorsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_IDS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListDetectorsResponse.memberNameToFieldInitializer();
    private final List<String> detectorIds;
    private final String nextToken;

    private ListDetectorsResponse(BuilderImpl builder) {
        super(builder);
        this.detectorIds = builder.detectorIds;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasDetectorIds() {
        return this.detectorIds != null && !(this.detectorIds instanceof SdkAutoConstructList);
    }

    public final List<String> detectorIds() {
        return this.detectorIds;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDetectorIds() ? this.detectorIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDetectorsResponse)) {
            return false;
        }
        ListDetectorsResponse other = (ListDetectorsResponse)((Object)obj);
        return this.hasDetectorIds() == other.hasDetectorIds() && Objects.equals(this.detectorIds(), other.detectorIds()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListDetectorsResponse").add("DetectorIds", this.hasDetectorIds() ? this.detectorIds() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DetectorIds": {
                return Optional.ofNullable(clazz.cast(this.detectorIds()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("detectorIds", DETECTOR_IDS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDetectorsResponse, T> g) {
        return obj -> g.apply((ListDetectorsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GuardDutyResponse.BuilderImpl
    implements Builder {
        private List<String> detectorIds = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDetectorsResponse model) {
            super(model);
            this.detectorIds(model.detectorIds);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getDetectorIds() {
            if (this.detectorIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.detectorIds;
        }

        public final void setDetectorIds(Collection<String> detectorIds) {
            this.detectorIds = DetectorIdsCopier.copy(detectorIds);
        }

        @Override
        public final Builder detectorIds(Collection<String> detectorIds) {
            this.detectorIds = DetectorIdsCopier.copy(detectorIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder detectorIds(String ... detectorIds) {
            this.detectorIds(Arrays.asList(detectorIds));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDetectorsResponse build() {
            return new ListDetectorsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GuardDutyResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDetectorsResponse> {
        public Builder detectorIds(Collection<String> var1);

        public Builder detectorIds(String ... var1);

        public Builder nextToken(String var1);
    }
}

