/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.guardduty.model.CoverageEc2InstanceDetails;
import software.amazon.awssdk.services.guardduty.model.CoverageEcsClusterDetails;
import software.amazon.awssdk.services.guardduty.model.CoverageEksClusterDetails;
import software.amazon.awssdk.services.guardduty.model.ResourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CoverageResourceDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CoverageResourceDetails> {
    private static final SdkField<CoverageEksClusterDetails> EKS_CLUSTER_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EksClusterDetails").getter(CoverageResourceDetails.getter(CoverageResourceDetails::eksClusterDetails)).setter(CoverageResourceDetails.setter(Builder::eksClusterDetails)).constructor(CoverageEksClusterDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eksClusterDetails").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(CoverageResourceDetails.getter(CoverageResourceDetails::resourceTypeAsString)).setter(CoverageResourceDetails.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final SdkField<CoverageEcsClusterDetails> ECS_CLUSTER_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EcsClusterDetails").getter(CoverageResourceDetails.getter(CoverageResourceDetails::ecsClusterDetails)).setter(CoverageResourceDetails.setter(Builder::ecsClusterDetails)).constructor(CoverageEcsClusterDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecsClusterDetails").build()}).build();
    private static final SdkField<CoverageEc2InstanceDetails> EC2_INSTANCE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Ec2InstanceDetails").getter(CoverageResourceDetails.getter(CoverageResourceDetails::ec2InstanceDetails)).setter(CoverageResourceDetails.setter(Builder::ec2InstanceDetails)).constructor(CoverageEc2InstanceDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2InstanceDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EKS_CLUSTER_DETAILS_FIELD, RESOURCE_TYPE_FIELD, ECS_CLUSTER_DETAILS_FIELD, EC2_INSTANCE_DETAILS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CoverageResourceDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final CoverageEksClusterDetails eksClusterDetails;
    private final String resourceType;
    private final CoverageEcsClusterDetails ecsClusterDetails;
    private final CoverageEc2InstanceDetails ec2InstanceDetails;

    private CoverageResourceDetails(BuilderImpl builder) {
        this.eksClusterDetails = builder.eksClusterDetails;
        this.resourceType = builder.resourceType;
        this.ecsClusterDetails = builder.ecsClusterDetails;
        this.ec2InstanceDetails = builder.ec2InstanceDetails;
    }

    public final CoverageEksClusterDetails eksClusterDetails() {
        return this.eksClusterDetails;
    }

    public final ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final CoverageEcsClusterDetails ecsClusterDetails() {
        return this.ecsClusterDetails;
    }

    public final CoverageEc2InstanceDetails ec2InstanceDetails() {
        return this.ec2InstanceDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eksClusterDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ecsClusterDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2InstanceDetails());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CoverageResourceDetails)) {
            return false;
        }
        CoverageResourceDetails other = (CoverageResourceDetails)obj;
        return Objects.equals(this.eksClusterDetails(), other.eksClusterDetails()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.ecsClusterDetails(), other.ecsClusterDetails()) && Objects.equals(this.ec2InstanceDetails(), other.ec2InstanceDetails());
    }

    public final String toString() {
        return ToString.builder((String)"CoverageResourceDetails").add("EksClusterDetails", (Object)this.eksClusterDetails()).add("ResourceType", (Object)this.resourceTypeAsString()).add("EcsClusterDetails", (Object)this.ecsClusterDetails()).add("Ec2InstanceDetails", (Object)this.ec2InstanceDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EksClusterDetails": {
                return Optional.ofNullable(clazz.cast(this.eksClusterDetails()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "EcsClusterDetails": {
                return Optional.ofNullable(clazz.cast(this.ecsClusterDetails()));
            }
            case "Ec2InstanceDetails": {
                return Optional.ofNullable(clazz.cast(this.ec2InstanceDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("eksClusterDetails", EKS_CLUSTER_DETAILS_FIELD);
        map.put("resourceType", RESOURCE_TYPE_FIELD);
        map.put("ecsClusterDetails", ECS_CLUSTER_DETAILS_FIELD);
        map.put("ec2InstanceDetails", EC2_INSTANCE_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CoverageResourceDetails, T> g) {
        return obj -> g.apply((CoverageResourceDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private CoverageEksClusterDetails eksClusterDetails;
        private String resourceType;
        private CoverageEcsClusterDetails ecsClusterDetails;
        private CoverageEc2InstanceDetails ec2InstanceDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(CoverageResourceDetails model) {
            this.eksClusterDetails(model.eksClusterDetails);
            this.resourceType(model.resourceType);
            this.ecsClusterDetails(model.ecsClusterDetails);
            this.ec2InstanceDetails(model.ec2InstanceDetails);
        }

        public final CoverageEksClusterDetails.Builder getEksClusterDetails() {
            return this.eksClusterDetails != null ? this.eksClusterDetails.toBuilder() : null;
        }

        public final void setEksClusterDetails(CoverageEksClusterDetails.BuilderImpl eksClusterDetails) {
            this.eksClusterDetails = eksClusterDetails != null ? eksClusterDetails.build() : null;
        }

        @Override
        public final Builder eksClusterDetails(CoverageEksClusterDetails eksClusterDetails) {
            this.eksClusterDetails = eksClusterDetails;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final CoverageEcsClusterDetails.Builder getEcsClusterDetails() {
            return this.ecsClusterDetails != null ? this.ecsClusterDetails.toBuilder() : null;
        }

        public final void setEcsClusterDetails(CoverageEcsClusterDetails.BuilderImpl ecsClusterDetails) {
            this.ecsClusterDetails = ecsClusterDetails != null ? ecsClusterDetails.build() : null;
        }

        @Override
        public final Builder ecsClusterDetails(CoverageEcsClusterDetails ecsClusterDetails) {
            this.ecsClusterDetails = ecsClusterDetails;
            return this;
        }

        public final CoverageEc2InstanceDetails.Builder getEc2InstanceDetails() {
            return this.ec2InstanceDetails != null ? this.ec2InstanceDetails.toBuilder() : null;
        }

        public final void setEc2InstanceDetails(CoverageEc2InstanceDetails.BuilderImpl ec2InstanceDetails) {
            this.ec2InstanceDetails = ec2InstanceDetails != null ? ec2InstanceDetails.build() : null;
        }

        @Override
        public final Builder ec2InstanceDetails(CoverageEc2InstanceDetails ec2InstanceDetails) {
            this.ec2InstanceDetails = ec2InstanceDetails;
            return this;
        }

        public CoverageResourceDetails build() {
            return new CoverageResourceDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CoverageResourceDetails> {
        public Builder eksClusterDetails(CoverageEksClusterDetails var1);

        default public Builder eksClusterDetails(Consumer<CoverageEksClusterDetails.Builder> eksClusterDetails) {
            return this.eksClusterDetails((CoverageEksClusterDetails)((CoverageEksClusterDetails.Builder)CoverageEksClusterDetails.builder().applyMutation(eksClusterDetails)).build());
        }

        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder ecsClusterDetails(CoverageEcsClusterDetails var1);

        default public Builder ecsClusterDetails(Consumer<CoverageEcsClusterDetails.Builder> ecsClusterDetails) {
            return this.ecsClusterDetails((CoverageEcsClusterDetails)((CoverageEcsClusterDetails.Builder)CoverageEcsClusterDetails.builder().applyMutation(ecsClusterDetails)).build());
        }

        public Builder ec2InstanceDetails(CoverageEc2InstanceDetails var1);

        default public Builder ec2InstanceDetails(Consumer<CoverageEc2InstanceDetails.Builder> ec2InstanceDetails) {
            return this.ec2InstanceDetails((CoverageEc2InstanceDetails)((CoverageEc2InstanceDetails.Builder)CoverageEc2InstanceDetails.builder().applyMutation(ec2InstanceDetails)).build());
        }
    }
}

