/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.guardduty.model.FindingResourceType;
import software.amazon.awssdk.services.guardduty.model.ResourceData;
import software.amazon.awssdk.services.guardduty.model.Tag;
import software.amazon.awssdk.services.guardduty.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceV2
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceV2> {
    private static final SdkField<String> UID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Uid").getter(ResourceV2.getter(ResourceV2::uid)).setter(ResourceV2.setter(Builder::uid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uid").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ResourceV2.getter(ResourceV2::name)).setter(ResourceV2.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(ResourceV2.getter(ResourceV2::accountId)).setter(ResourceV2.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(ResourceV2.getter(ResourceV2::resourceTypeAsString)).setter(ResourceV2.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Region").getter(ResourceV2.getter(ResourceV2::region)).setter(ResourceV2.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()}).build();
    private static final SdkField<String> SERVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Service").getter(ResourceV2.getter(ResourceV2::service)).setter(ResourceV2.setter(Builder::service)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("service").build()}).build();
    private static final SdkField<String> CLOUD_PARTITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CloudPartition").getter(ResourceV2.getter(ResourceV2::cloudPartition)).setter(ResourceV2.setter(Builder::cloudPartition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudPartition").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(ResourceV2.getter(ResourceV2::tags)).setter(ResourceV2.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ResourceData> DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Data").getter(ResourceV2.getter(ResourceV2::data)).setter(ResourceV2.setter(Builder::data)).constructor(ResourceData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("data").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UID_FIELD, NAME_FIELD, ACCOUNT_ID_FIELD, RESOURCE_TYPE_FIELD, REGION_FIELD, SERVICE_FIELD, CLOUD_PARTITION_FIELD, TAGS_FIELD, DATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ResourceV2.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String uid;
    private final String name;
    private final String accountId;
    private final String resourceType;
    private final String region;
    private final String service;
    private final String cloudPartition;
    private final List<Tag> tags;
    private final ResourceData data;

    private ResourceV2(BuilderImpl builder) {
        this.uid = builder.uid;
        this.name = builder.name;
        this.accountId = builder.accountId;
        this.resourceType = builder.resourceType;
        this.region = builder.region;
        this.service = builder.service;
        this.cloudPartition = builder.cloudPartition;
        this.tags = builder.tags;
        this.data = builder.data;
    }

    public final String uid() {
        return this.uid;
    }

    public final String name() {
        return this.name;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final FindingResourceType resourceType() {
        return FindingResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final String region() {
        return this.region;
    }

    public final String service() {
        return this.service;
    }

    public final String cloudPartition() {
        return this.cloudPartition;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final ResourceData data() {
        return this.data;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.uid());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.service());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudPartition());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.data());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceV2)) {
            return false;
        }
        ResourceV2 other = (ResourceV2)obj;
        return Objects.equals(this.uid(), other.uid()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.service(), other.service()) && Objects.equals(this.cloudPartition(), other.cloudPartition()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.data(), other.data());
    }

    public final String toString() {
        return ToString.builder((String)"ResourceV2").add("Uid", (Object)this.uid()).add("Name", (Object)this.name()).add("AccountId", (Object)this.accountId()).add("ResourceType", (Object)this.resourceTypeAsString()).add("Region", (Object)this.region()).add("Service", (Object)this.service()).add("CloudPartition", (Object)this.cloudPartition()).add("Tags", this.hasTags() ? this.tags() : null).add("Data", (Object)this.data()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Uid": {
                return Optional.ofNullable(clazz.cast(this.uid()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "Region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "Service": {
                return Optional.ofNullable(clazz.cast(this.service()));
            }
            case "CloudPartition": {
                return Optional.ofNullable(clazz.cast(this.cloudPartition()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "Data": {
                return Optional.ofNullable(clazz.cast(this.data()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("uid", UID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("resourceType", RESOURCE_TYPE_FIELD);
        map.put("region", REGION_FIELD);
        map.put("service", SERVICE_FIELD);
        map.put("cloudPartition", CLOUD_PARTITION_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("data", DATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceV2, T> g) {
        return obj -> g.apply((ResourceV2)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String uid;
        private String name;
        private String accountId;
        private String resourceType;
        private String region;
        private String service;
        private String cloudPartition;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private ResourceData data;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceV2 model) {
            this.uid(model.uid);
            this.name(model.name);
            this.accountId(model.accountId);
            this.resourceType(model.resourceType);
            this.region(model.region);
            this.service(model.service);
            this.cloudPartition(model.cloudPartition);
            this.tags(model.tags);
            this.data(model.data);
        }

        public final String getUid() {
            return this.uid;
        }

        public final void setUid(String uid) {
            this.uid = uid;
        }

        @Override
        public final Builder uid(String uid) {
            this.uid = uid;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(FindingResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getService() {
            return this.service;
        }

        public final void setService(String service) {
            this.service = service;
        }

        @Override
        public final Builder service(String service) {
            this.service = service;
            return this;
        }

        public final String getCloudPartition() {
            return this.cloudPartition;
        }

        public final void setCloudPartition(String cloudPartition) {
            this.cloudPartition = cloudPartition;
        }

        @Override
        public final Builder cloudPartition(String cloudPartition) {
            this.cloudPartition = cloudPartition;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ResourceData.Builder getData() {
            return this.data != null ? this.data.toBuilder() : null;
        }

        public final void setData(ResourceData.BuilderImpl data) {
            this.data = data != null ? data.build() : null;
        }

        @Override
        public final Builder data(ResourceData data) {
            this.data = data;
            return this;
        }

        public ResourceV2 build() {
            return new ResourceV2(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceV2> {
        public Builder uid(String var1);

        public Builder name(String var1);

        public Builder accountId(String var1);

        public Builder resourceType(String var1);

        public Builder resourceType(FindingResourceType var1);

        public Builder region(String var1);

        public Builder service(String var1);

        public Builder cloudPartition(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder data(ResourceData var1);

        default public Builder data(Consumer<ResourceData.Builder> data) {
            return this.data((ResourceData)((ResourceData.Builder)ResourceData.builder().applyMutation(data)).build());
        }
    }
}

