/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.guardduty.GuardDutyAsyncClient;
import software.amazon.awssdk.services.guardduty.model.ListIpSetsRequest;
import software.amazon.awssdk.services.guardduty.model.ListIpSetsResponse;

public class ListIPSetsPublisher
implements SdkPublisher<ListIpSetsResponse> {
    private final GuardDutyAsyncClient client;
    private final ListIpSetsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListIPSetsPublisher(GuardDutyAsyncClient client, ListIpSetsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListIPSetsPublisher(GuardDutyAsyncClient client, ListIpSetsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListIpSetsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListIpSetsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> ipSetIds() {
        Function<ListIpSetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.ipSetIds() != null) {
                return response.ipSetIds().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListIpSetsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final ListIPSetsPublisher resume(ListIpSetsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListIPSetsPublisher(this.client, (ListIpSetsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListIPSetsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListIpSetsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListIpSetsResponseFetcher
    implements AsyncPageFetcher<ListIpSetsResponse> {
        private ListIpSetsResponseFetcher() {
        }

        public boolean hasNextPage(ListIpSetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListIpSetsResponse> nextPage(ListIpSetsResponse previousPage) {
            if (previousPage == null) {
                return ListIPSetsPublisher.this.client.listIPSets(ListIPSetsPublisher.this.firstRequest);
            }
            return ListIPSetsPublisher.this.client.listIPSets((ListIpSetsRequest)((Object)ListIPSetsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

