/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.guardduty.model.LoginAttribute;
import software.amazon.awssdk.services.guardduty.model.LoginAttributesCopier;
import software.amazon.awssdk.services.guardduty.model.RemoteIpDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RdsLoginAttemptAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RdsLoginAttemptAction> {
    private static final SdkField<RemoteIpDetails> REMOTE_IP_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RemoteIpDetails").getter(RdsLoginAttemptAction.getter(RdsLoginAttemptAction::remoteIpDetails)).setter(RdsLoginAttemptAction.setter(Builder::remoteIpDetails)).constructor(RemoteIpDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteIpDetails").build()}).build();
    private static final SdkField<List<LoginAttribute>> LOGIN_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LoginAttributes").getter(RdsLoginAttemptAction.getter(RdsLoginAttemptAction::loginAttributes)).setter(RdsLoginAttemptAction.setter(Builder::loginAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoginAttributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LoginAttribute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REMOTE_IP_DETAILS_FIELD, LOGIN_ATTRIBUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("remoteIpDetails", REMOTE_IP_DETAILS_FIELD);
            this.put("LoginAttributes", LOGIN_ATTRIBUTES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final RemoteIpDetails remoteIpDetails;
    private final List<LoginAttribute> loginAttributes;

    private RdsLoginAttemptAction(BuilderImpl builder) {
        this.remoteIpDetails = builder.remoteIpDetails;
        this.loginAttributes = builder.loginAttributes;
    }

    public final RemoteIpDetails remoteIpDetails() {
        return this.remoteIpDetails;
    }

    public final boolean hasLoginAttributes() {
        return this.loginAttributes != null && !(this.loginAttributes instanceof SdkAutoConstructList);
    }

    public final List<LoginAttribute> loginAttributes() {
        return this.loginAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.remoteIpDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLoginAttributes() ? this.loginAttributes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RdsLoginAttemptAction)) {
            return false;
        }
        RdsLoginAttemptAction other = (RdsLoginAttemptAction)obj;
        return Objects.equals(this.remoteIpDetails(), other.remoteIpDetails()) && this.hasLoginAttributes() == other.hasLoginAttributes() && Objects.equals(this.loginAttributes(), other.loginAttributes());
    }

    public final String toString() {
        return ToString.builder((String)"RdsLoginAttemptAction").add("RemoteIpDetails", (Object)this.remoteIpDetails()).add("LoginAttributes", this.hasLoginAttributes() ? this.loginAttributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RemoteIpDetails": {
                return Optional.ofNullable(clazz.cast(this.remoteIpDetails()));
            }
            case "LoginAttributes": {
                return Optional.ofNullable(clazz.cast(this.loginAttributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RdsLoginAttemptAction, T> g) {
        return obj -> g.apply((RdsLoginAttemptAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private RemoteIpDetails remoteIpDetails;
        private List<LoginAttribute> loginAttributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RdsLoginAttemptAction model) {
            this.remoteIpDetails(model.remoteIpDetails);
            this.loginAttributes(model.loginAttributes);
        }

        public final RemoteIpDetails.Builder getRemoteIpDetails() {
            return this.remoteIpDetails != null ? this.remoteIpDetails.toBuilder() : null;
        }

        public final void setRemoteIpDetails(RemoteIpDetails.BuilderImpl remoteIpDetails) {
            this.remoteIpDetails = remoteIpDetails != null ? remoteIpDetails.build() : null;
        }

        @Override
        public final Builder remoteIpDetails(RemoteIpDetails remoteIpDetails) {
            this.remoteIpDetails = remoteIpDetails;
            return this;
        }

        public final List<LoginAttribute.Builder> getLoginAttributes() {
            List<LoginAttribute.Builder> result = LoginAttributesCopier.copyToBuilder(this.loginAttributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLoginAttributes(Collection<LoginAttribute.BuilderImpl> loginAttributes) {
            this.loginAttributes = LoginAttributesCopier.copyFromBuilder(loginAttributes);
        }

        @Override
        public final Builder loginAttributes(Collection<LoginAttribute> loginAttributes) {
            this.loginAttributes = LoginAttributesCopier.copy(loginAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loginAttributes(LoginAttribute ... loginAttributes) {
            this.loginAttributes(Arrays.asList(loginAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loginAttributes(Consumer<LoginAttribute.Builder> ... loginAttributes) {
            this.loginAttributes(Stream.of(loginAttributes).map(c -> (LoginAttribute)((LoginAttribute.Builder)LoginAttribute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public RdsLoginAttemptAction build() {
            return new RdsLoginAttemptAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RdsLoginAttemptAction> {
        public Builder remoteIpDetails(RemoteIpDetails var1);

        default public Builder remoteIpDetails(Consumer<RemoteIpDetails.Builder> remoteIpDetails) {
            return this.remoteIpDetails((RemoteIpDetails)((RemoteIpDetails.Builder)RemoteIpDetails.builder().applyMutation(remoteIpDetails)).build());
        }

        public Builder loginAttributes(Collection<LoginAttribute> var1);

        public Builder loginAttributes(LoginAttribute ... var1);

        public Builder loginAttributes(Consumer<LoginAttribute.Builder> ... var1);
    }
}

