/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.guardduty.model.AddonDetails;
import software.amazon.awssdk.services.guardduty.model.ManagementType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CoverageEksClusterDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CoverageEksClusterDetails> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterName").getter(CoverageEksClusterDetails.getter(CoverageEksClusterDetails::clusterName)).setter(CoverageEksClusterDetails.setter(Builder::clusterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterName").build()}).build();
    private static final SdkField<Long> COVERED_NODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("CoveredNodes").getter(CoverageEksClusterDetails.getter(CoverageEksClusterDetails::coveredNodes)).setter(CoverageEksClusterDetails.setter(Builder::coveredNodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("coveredNodes").build()}).build();
    private static final SdkField<Long> COMPATIBLE_NODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("CompatibleNodes").getter(CoverageEksClusterDetails.getter(CoverageEksClusterDetails::compatibleNodes)).setter(CoverageEksClusterDetails.setter(Builder::compatibleNodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("compatibleNodes").build()}).build();
    private static final SdkField<AddonDetails> ADDON_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AddonDetails").getter(CoverageEksClusterDetails.getter(CoverageEksClusterDetails::addonDetails)).setter(CoverageEksClusterDetails.setter(Builder::addonDetails)).constructor(AddonDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addonDetails").build()}).build();
    private static final SdkField<String> MANAGEMENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ManagementType").getter(CoverageEksClusterDetails.getter(CoverageEksClusterDetails::managementTypeAsString)).setter(CoverageEksClusterDetails.setter(Builder::managementType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managementType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD, COVERED_NODES_FIELD, COMPATIBLE_NODES_FIELD, ADDON_DETAILS_FIELD, MANAGEMENT_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("clusterName", CLUSTER_NAME_FIELD);
            this.put("coveredNodes", COVERED_NODES_FIELD);
            this.put("compatibleNodes", COMPATIBLE_NODES_FIELD);
            this.put("addonDetails", ADDON_DETAILS_FIELD);
            this.put("managementType", MANAGEMENT_TYPE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String clusterName;
    private final Long coveredNodes;
    private final Long compatibleNodes;
    private final AddonDetails addonDetails;
    private final String managementType;

    private CoverageEksClusterDetails(BuilderImpl builder) {
        this.clusterName = builder.clusterName;
        this.coveredNodes = builder.coveredNodes;
        this.compatibleNodes = builder.compatibleNodes;
        this.addonDetails = builder.addonDetails;
        this.managementType = builder.managementType;
    }

    public final String clusterName() {
        return this.clusterName;
    }

    public final Long coveredNodes() {
        return this.coveredNodes;
    }

    public final Long compatibleNodes() {
        return this.compatibleNodes;
    }

    public final AddonDetails addonDetails() {
        return this.addonDetails;
    }

    public final ManagementType managementType() {
        return ManagementType.fromValue(this.managementType);
    }

    public final String managementTypeAsString() {
        return this.managementType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.coveredNodes());
        hashCode = 31 * hashCode + Objects.hashCode(this.compatibleNodes());
        hashCode = 31 * hashCode + Objects.hashCode(this.addonDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.managementTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CoverageEksClusterDetails)) {
            return false;
        }
        CoverageEksClusterDetails other = (CoverageEksClusterDetails)obj;
        return Objects.equals(this.clusterName(), other.clusterName()) && Objects.equals(this.coveredNodes(), other.coveredNodes()) && Objects.equals(this.compatibleNodes(), other.compatibleNodes()) && Objects.equals(this.addonDetails(), other.addonDetails()) && Objects.equals(this.managementTypeAsString(), other.managementTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CoverageEksClusterDetails").add("ClusterName", (Object)this.clusterName()).add("CoveredNodes", (Object)this.coveredNodes()).add("CompatibleNodes", (Object)this.compatibleNodes()).add("AddonDetails", (Object)this.addonDetails()).add("ManagementType", (Object)this.managementTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterName": {
                return Optional.ofNullable(clazz.cast(this.clusterName()));
            }
            case "CoveredNodes": {
                return Optional.ofNullable(clazz.cast(this.coveredNodes()));
            }
            case "CompatibleNodes": {
                return Optional.ofNullable(clazz.cast(this.compatibleNodes()));
            }
            case "AddonDetails": {
                return Optional.ofNullable(clazz.cast(this.addonDetails()));
            }
            case "ManagementType": {
                return Optional.ofNullable(clazz.cast(this.managementTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CoverageEksClusterDetails, T> g) {
        return obj -> g.apply((CoverageEksClusterDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String clusterName;
        private Long coveredNodes;
        private Long compatibleNodes;
        private AddonDetails addonDetails;
        private String managementType;

        private BuilderImpl() {
        }

        private BuilderImpl(CoverageEksClusterDetails model) {
            this.clusterName(model.clusterName);
            this.coveredNodes(model.coveredNodes);
            this.compatibleNodes(model.compatibleNodes);
            this.addonDetails(model.addonDetails);
            this.managementType(model.managementType);
        }

        public final String getClusterName() {
            return this.clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final Long getCoveredNodes() {
            return this.coveredNodes;
        }

        public final void setCoveredNodes(Long coveredNodes) {
            this.coveredNodes = coveredNodes;
        }

        @Override
        public final Builder coveredNodes(Long coveredNodes) {
            this.coveredNodes = coveredNodes;
            return this;
        }

        public final Long getCompatibleNodes() {
            return this.compatibleNodes;
        }

        public final void setCompatibleNodes(Long compatibleNodes) {
            this.compatibleNodes = compatibleNodes;
        }

        @Override
        public final Builder compatibleNodes(Long compatibleNodes) {
            this.compatibleNodes = compatibleNodes;
            return this;
        }

        public final AddonDetails.Builder getAddonDetails() {
            return this.addonDetails != null ? this.addonDetails.toBuilder() : null;
        }

        public final void setAddonDetails(AddonDetails.BuilderImpl addonDetails) {
            this.addonDetails = addonDetails != null ? addonDetails.build() : null;
        }

        @Override
        public final Builder addonDetails(AddonDetails addonDetails) {
            this.addonDetails = addonDetails;
            return this;
        }

        public final String getManagementType() {
            return this.managementType;
        }

        public final void setManagementType(String managementType) {
            this.managementType = managementType;
        }

        @Override
        public final Builder managementType(String managementType) {
            this.managementType = managementType;
            return this;
        }

        @Override
        public final Builder managementType(ManagementType managementType) {
            this.managementType(managementType == null ? null : managementType.toString());
            return this;
        }

        public CoverageEksClusterDetails build() {
            return new CoverageEksClusterDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CoverageEksClusterDetails> {
        public Builder clusterName(String var1);

        public Builder coveredNodes(Long var1);

        public Builder compatibleNodes(Long var1);

        public Builder addonDetails(AddonDetails var1);

        default public Builder addonDetails(Consumer<AddonDetails.Builder> addonDetails) {
            return this.addonDetails((AddonDetails)((AddonDetails.Builder)AddonDetails.builder().applyMutation(addonDetails)).build());
        }

        public Builder managementType(String var1);

        public Builder managementType(ManagementType var1);
    }
}

