/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SeverityStatistics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SeverityStatistics> {
    private static final SdkField<Instant> LAST_GENERATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastGeneratedAt").getter(SeverityStatistics.getter(SeverityStatistics::lastGeneratedAt)).setter(SeverityStatistics.setter(Builder::lastGeneratedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastGeneratedAt").build()}).build();
    private static final SdkField<Double> SEVERITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Severity").getter(SeverityStatistics.getter(SeverityStatistics::severity)).setter(SeverityStatistics.setter(Builder::severity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("severity").build()}).build();
    private static final SdkField<Integer> TOTAL_FINDINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalFindings").getter(SeverityStatistics.getter(SeverityStatistics::totalFindings)).setter(SeverityStatistics.setter(Builder::totalFindings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalFindings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAST_GENERATED_AT_FIELD, SEVERITY_FIELD, TOTAL_FINDINGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant lastGeneratedAt;
    private final Double severity;
    private final Integer totalFindings;

    private SeverityStatistics(BuilderImpl builder) {
        this.lastGeneratedAt = builder.lastGeneratedAt;
        this.severity = builder.severity;
        this.totalFindings = builder.totalFindings;
    }

    public final Instant lastGeneratedAt() {
        return this.lastGeneratedAt;
    }

    public final Double severity() {
        return this.severity;
    }

    public final Integer totalFindings() {
        return this.totalFindings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.lastGeneratedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.severity());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalFindings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SeverityStatistics)) {
            return false;
        }
        SeverityStatistics other = (SeverityStatistics)obj;
        return Objects.equals(this.lastGeneratedAt(), other.lastGeneratedAt()) && Objects.equals(this.severity(), other.severity()) && Objects.equals(this.totalFindings(), other.totalFindings());
    }

    public final String toString() {
        return ToString.builder((String)"SeverityStatistics").add("LastGeneratedAt", (Object)this.lastGeneratedAt()).add("Severity", (Object)this.severity()).add("TotalFindings", (Object)this.totalFindings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LastGeneratedAt": {
                return Optional.ofNullable(clazz.cast(this.lastGeneratedAt()));
            }
            case "Severity": {
                return Optional.ofNullable(clazz.cast(this.severity()));
            }
            case "TotalFindings": {
                return Optional.ofNullable(clazz.cast(this.totalFindings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SeverityStatistics, T> g) {
        return obj -> g.apply((SeverityStatistics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant lastGeneratedAt;
        private Double severity;
        private Integer totalFindings;

        private BuilderImpl() {
        }

        private BuilderImpl(SeverityStatistics model) {
            this.lastGeneratedAt(model.lastGeneratedAt);
            this.severity(model.severity);
            this.totalFindings(model.totalFindings);
        }

        public final Instant getLastGeneratedAt() {
            return this.lastGeneratedAt;
        }

        public final void setLastGeneratedAt(Instant lastGeneratedAt) {
            this.lastGeneratedAt = lastGeneratedAt;
        }

        @Override
        public final Builder lastGeneratedAt(Instant lastGeneratedAt) {
            this.lastGeneratedAt = lastGeneratedAt;
            return this;
        }

        public final Double getSeverity() {
            return this.severity;
        }

        public final void setSeverity(Double severity) {
            this.severity = severity;
        }

        @Override
        public final Builder severity(Double severity) {
            this.severity = severity;
            return this;
        }

        public final Integer getTotalFindings() {
            return this.totalFindings;
        }

        public final void setTotalFindings(Integer totalFindings) {
            this.totalFindings = totalFindings;
        }

        @Override
        public final Builder totalFindings(Integer totalFindings) {
            this.totalFindings = totalFindings;
            return this;
        }

        public SeverityStatistics build() {
            return new SeverityStatistics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SeverityStatistics> {
        public Builder lastGeneratedAt(Instant var1);

        public Builder severity(Double var1);

        public Builder totalFindings(Integer var1);
    }
}

