/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.guardduty.model.Observations;
import software.amazon.awssdk.services.guardduty.model.ProfileSubtype;
import software.amazon.awssdk.services.guardduty.model.ProfileType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AnomalyObject
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AnomalyObject> {
    private static final SdkField<String> PROFILE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProfileType").getter(AnomalyObject.getter(AnomalyObject::profileTypeAsString)).setter(AnomalyObject.setter(Builder::profileType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profileType").build()}).build();
    private static final SdkField<String> PROFILE_SUBTYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProfileSubtype").getter(AnomalyObject.getter(AnomalyObject::profileSubtypeAsString)).setter(AnomalyObject.setter(Builder::profileSubtype)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profileSubtype").build()}).build();
    private static final SdkField<Observations> OBSERVATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Observations").getter(AnomalyObject.getter(AnomalyObject::observations)).setter(AnomalyObject.setter(Builder::observations)).constructor(Observations::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("observations").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROFILE_TYPE_FIELD, PROFILE_SUBTYPE_FIELD, OBSERVATIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String profileType;
    private final String profileSubtype;
    private final Observations observations;

    private AnomalyObject(BuilderImpl builder) {
        this.profileType = builder.profileType;
        this.profileSubtype = builder.profileSubtype;
        this.observations = builder.observations;
    }

    public final ProfileType profileType() {
        return ProfileType.fromValue(this.profileType);
    }

    public final String profileTypeAsString() {
        return this.profileType;
    }

    public final ProfileSubtype profileSubtype() {
        return ProfileSubtype.fromValue(this.profileSubtype);
    }

    public final String profileSubtypeAsString() {
        return this.profileSubtype;
    }

    public final Observations observations() {
        return this.observations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.profileTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.profileSubtypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.observations());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnomalyObject)) {
            return false;
        }
        AnomalyObject other = (AnomalyObject)obj;
        return Objects.equals(this.profileTypeAsString(), other.profileTypeAsString()) && Objects.equals(this.profileSubtypeAsString(), other.profileSubtypeAsString()) && Objects.equals(this.observations(), other.observations());
    }

    public final String toString() {
        return ToString.builder((String)"AnomalyObject").add("ProfileType", (Object)this.profileTypeAsString()).add("ProfileSubtype", (Object)this.profileSubtypeAsString()).add("Observations", (Object)this.observations()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProfileType": {
                return Optional.ofNullable(clazz.cast(this.profileTypeAsString()));
            }
            case "ProfileSubtype": {
                return Optional.ofNullable(clazz.cast(this.profileSubtypeAsString()));
            }
            case "Observations": {
                return Optional.ofNullable(clazz.cast(this.observations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AnomalyObject, T> g) {
        return obj -> g.apply((AnomalyObject)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String profileType;
        private String profileSubtype;
        private Observations observations;

        private BuilderImpl() {
        }

        private BuilderImpl(AnomalyObject model) {
            this.profileType(model.profileType);
            this.profileSubtype(model.profileSubtype);
            this.observations(model.observations);
        }

        public final String getProfileType() {
            return this.profileType;
        }

        public final void setProfileType(String profileType) {
            this.profileType = profileType;
        }

        @Override
        public final Builder profileType(String profileType) {
            this.profileType = profileType;
            return this;
        }

        @Override
        public final Builder profileType(ProfileType profileType) {
            this.profileType(profileType == null ? null : profileType.toString());
            return this;
        }

        public final String getProfileSubtype() {
            return this.profileSubtype;
        }

        public final void setProfileSubtype(String profileSubtype) {
            this.profileSubtype = profileSubtype;
        }

        @Override
        public final Builder profileSubtype(String profileSubtype) {
            this.profileSubtype = profileSubtype;
            return this;
        }

        @Override
        public final Builder profileSubtype(ProfileSubtype profileSubtype) {
            this.profileSubtype(profileSubtype == null ? null : profileSubtype.toString());
            return this;
        }

        public final Observations.Builder getObservations() {
            return this.observations != null ? this.observations.toBuilder() : null;
        }

        public final void setObservations(Observations.BuilderImpl observations) {
            this.observations = observations != null ? observations.build() : null;
        }

        @Override
        public final Builder observations(Observations observations) {
            this.observations = observations;
            return this;
        }

        public AnomalyObject build() {
            return new AnomalyObject(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AnomalyObject> {
        public Builder profileType(String var1);

        public Builder profileType(ProfileType var1);

        public Builder profileSubtype(String var1);

        public Builder profileSubtype(ProfileSubtype var1);

        public Builder observations(Observations var1);

        default public Builder observations(Consumer<Observations.Builder> observations) {
            return this.observations((Observations)((Observations.Builder)Observations.builder().applyMutation(observations)).build());
        }
    }
}

