/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.guardduty.model.FindingTypesCopier;
import software.amazon.awssdk.services.guardduty.model.GuardDutyRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateSampleFindingsRequest
extends GuardDutyRequest
implements ToCopyableBuilder<Builder, CreateSampleFindingsRequest> {
    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DetectorId").getter(CreateSampleFindingsRequest.getter(CreateSampleFindingsRequest::detectorId)).setter(CreateSampleFindingsRequest.setter(Builder::detectorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("detectorId").build()}).build();
    private static final SdkField<List<String>> FINDING_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FindingTypes").getter(CreateSampleFindingsRequest.getter(CreateSampleFindingsRequest::findingTypes)).setter(CreateSampleFindingsRequest.setter(Builder::findingTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_ID_FIELD, FINDING_TYPES_FIELD));
    private final String detectorId;
    private final List<String> findingTypes;

    private CreateSampleFindingsRequest(BuilderImpl builder) {
        super(builder);
        this.detectorId = builder.detectorId;
        this.findingTypes = builder.findingTypes;
    }

    public final String detectorId() {
        return this.detectorId;
    }

    public final boolean hasFindingTypes() {
        return this.findingTypes != null && !(this.findingTypes instanceof SdkAutoConstructList);
    }

    public final List<String> findingTypes() {
        return this.findingTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFindingTypes() ? this.findingTypes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSampleFindingsRequest)) {
            return false;
        }
        CreateSampleFindingsRequest other = (CreateSampleFindingsRequest)((Object)obj);
        return Objects.equals(this.detectorId(), other.detectorId()) && this.hasFindingTypes() == other.hasFindingTypes() && Objects.equals(this.findingTypes(), other.findingTypes());
    }

    public final String toString() {
        return ToString.builder((String)"CreateSampleFindingsRequest").add("DetectorId", (Object)this.detectorId()).add("FindingTypes", this.hasFindingTypes() ? this.findingTypes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DetectorId": {
                return Optional.ofNullable(clazz.cast(this.detectorId()));
            }
            case "FindingTypes": {
                return Optional.ofNullable(clazz.cast(this.findingTypes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSampleFindingsRequest, T> g) {
        return obj -> g.apply((CreateSampleFindingsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GuardDutyRequest.BuilderImpl
    implements Builder {
        private String detectorId;
        private List<String> findingTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSampleFindingsRequest model) {
            super(model);
            this.detectorId(model.detectorId);
            this.findingTypes(model.findingTypes);
        }

        public final String getDetectorId() {
            return this.detectorId;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final Collection<String> getFindingTypes() {
            if (this.findingTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.findingTypes;
        }

        public final void setFindingTypes(Collection<String> findingTypes) {
            this.findingTypes = FindingTypesCopier.copy(findingTypes);
        }

        @Override
        public final Builder findingTypes(Collection<String> findingTypes) {
            this.findingTypes = FindingTypesCopier.copy(findingTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingTypes(String ... findingTypes) {
            this.findingTypes(Arrays.asList(findingTypes));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSampleFindingsRequest build() {
            return new CreateSampleFindingsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GuardDutyRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateSampleFindingsRequest> {
        public Builder detectorId(String var1);

        public Builder findingTypes(Collection<String> var1);

        public Builder findingTypes(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

