/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.guardduty.model.FlagsListCopier;
import software.amazon.awssdk.services.guardduty.model.MemoryRegionsListCopier;
import software.amazon.awssdk.services.guardduty.model.ProcessDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RuntimeContext
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RuntimeContext> {
    private static final SdkField<ProcessDetails> MODIFYING_PROCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ModifyingProcess").getter(RuntimeContext.getter(RuntimeContext::modifyingProcess)).setter(RuntimeContext.setter(Builder::modifyingProcess)).constructor(ProcessDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modifyingProcess").build()}).build();
    private static final SdkField<Instant> MODIFIED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ModifiedAt").getter(RuntimeContext.getter(RuntimeContext::modifiedAt)).setter(RuntimeContext.setter(Builder::modifiedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modifiedAt").build()}).build();
    private static final SdkField<String> SCRIPT_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScriptPath").getter(RuntimeContext.getter(RuntimeContext::scriptPath)).setter(RuntimeContext.setter(Builder::scriptPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scriptPath").build()}).build();
    private static final SdkField<String> LIBRARY_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LibraryPath").getter(RuntimeContext.getter(RuntimeContext::libraryPath)).setter(RuntimeContext.setter(Builder::libraryPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("libraryPath").build()}).build();
    private static final SdkField<String> LD_PRELOAD_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LdPreloadValue").getter(RuntimeContext.getter(RuntimeContext::ldPreloadValue)).setter(RuntimeContext.setter(Builder::ldPreloadValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ldPreloadValue").build()}).build();
    private static final SdkField<String> SOCKET_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SocketPath").getter(RuntimeContext.getter(RuntimeContext::socketPath)).setter(RuntimeContext.setter(Builder::socketPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("socketPath").build()}).build();
    private static final SdkField<String> RUNC_BINARY_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuncBinaryPath").getter(RuntimeContext.getter(RuntimeContext::runcBinaryPath)).setter(RuntimeContext.setter(Builder::runcBinaryPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runcBinaryPath").build()}).build();
    private static final SdkField<String> RELEASE_AGENT_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReleaseAgentPath").getter(RuntimeContext.getter(RuntimeContext::releaseAgentPath)).setter(RuntimeContext.setter(Builder::releaseAgentPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("releaseAgentPath").build()}).build();
    private static final SdkField<String> MOUNT_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MountSource").getter(RuntimeContext.getter(RuntimeContext::mountSource)).setter(RuntimeContext.setter(Builder::mountSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mountSource").build()}).build();
    private static final SdkField<String> MOUNT_TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MountTarget").getter(RuntimeContext.getter(RuntimeContext::mountTarget)).setter(RuntimeContext.setter(Builder::mountTarget)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mountTarget").build()}).build();
    private static final SdkField<String> FILE_SYSTEM_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileSystemType").getter(RuntimeContext.getter(RuntimeContext::fileSystemType)).setter(RuntimeContext.setter(Builder::fileSystemType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileSystemType").build()}).build();
    private static final SdkField<List<String>> FLAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Flags").getter(RuntimeContext.getter(RuntimeContext::flags)).setter(RuntimeContext.setter(Builder::flags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MODULE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModuleName").getter(RuntimeContext.getter(RuntimeContext::moduleName)).setter(RuntimeContext.setter(Builder::moduleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("moduleName").build()}).build();
    private static final SdkField<String> MODULE_FILE_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModuleFilePath").getter(RuntimeContext.getter(RuntimeContext::moduleFilePath)).setter(RuntimeContext.setter(Builder::moduleFilePath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("moduleFilePath").build()}).build();
    private static final SdkField<String> MODULE_SHA256_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModuleSha256").getter(RuntimeContext.getter(RuntimeContext::moduleSha256)).setter(RuntimeContext.setter(Builder::moduleSha256)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("moduleSha256").build()}).build();
    private static final SdkField<String> SHELL_HISTORY_FILE_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ShellHistoryFilePath").getter(RuntimeContext.getter(RuntimeContext::shellHistoryFilePath)).setter(RuntimeContext.setter(Builder::shellHistoryFilePath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shellHistoryFilePath").build()}).build();
    private static final SdkField<ProcessDetails> TARGET_PROCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TargetProcess").getter(RuntimeContext.getter(RuntimeContext::targetProcess)).setter(RuntimeContext.setter(Builder::targetProcess)).constructor(ProcessDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetProcess").build()}).build();
    private static final SdkField<String> ADDRESS_FAMILY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AddressFamily").getter(RuntimeContext.getter(RuntimeContext::addressFamily)).setter(RuntimeContext.setter(Builder::addressFamily)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addressFamily").build()}).build();
    private static final SdkField<Integer> IANA_PROTOCOL_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("IanaProtocolNumber").getter(RuntimeContext.getter(RuntimeContext::ianaProtocolNumber)).setter(RuntimeContext.setter(Builder::ianaProtocolNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ianaProtocolNumber").build()}).build();
    private static final SdkField<List<String>> MEMORY_REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MemoryRegions").getter(RuntimeContext.getter(RuntimeContext::memoryRegions)).setter(RuntimeContext.setter(Builder::memoryRegions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memoryRegions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODIFYING_PROCESS_FIELD, MODIFIED_AT_FIELD, SCRIPT_PATH_FIELD, LIBRARY_PATH_FIELD, LD_PRELOAD_VALUE_FIELD, SOCKET_PATH_FIELD, RUNC_BINARY_PATH_FIELD, RELEASE_AGENT_PATH_FIELD, MOUNT_SOURCE_FIELD, MOUNT_TARGET_FIELD, FILE_SYSTEM_TYPE_FIELD, FLAGS_FIELD, MODULE_NAME_FIELD, MODULE_FILE_PATH_FIELD, MODULE_SHA256_FIELD, SHELL_HISTORY_FILE_PATH_FIELD, TARGET_PROCESS_FIELD, ADDRESS_FAMILY_FIELD, IANA_PROTOCOL_NUMBER_FIELD, MEMORY_REGIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final ProcessDetails modifyingProcess;
    private final Instant modifiedAt;
    private final String scriptPath;
    private final String libraryPath;
    private final String ldPreloadValue;
    private final String socketPath;
    private final String runcBinaryPath;
    private final String releaseAgentPath;
    private final String mountSource;
    private final String mountTarget;
    private final String fileSystemType;
    private final List<String> flags;
    private final String moduleName;
    private final String moduleFilePath;
    private final String moduleSha256;
    private final String shellHistoryFilePath;
    private final ProcessDetails targetProcess;
    private final String addressFamily;
    private final Integer ianaProtocolNumber;
    private final List<String> memoryRegions;

    private RuntimeContext(BuilderImpl builder) {
        this.modifyingProcess = builder.modifyingProcess;
        this.modifiedAt = builder.modifiedAt;
        this.scriptPath = builder.scriptPath;
        this.libraryPath = builder.libraryPath;
        this.ldPreloadValue = builder.ldPreloadValue;
        this.socketPath = builder.socketPath;
        this.runcBinaryPath = builder.runcBinaryPath;
        this.releaseAgentPath = builder.releaseAgentPath;
        this.mountSource = builder.mountSource;
        this.mountTarget = builder.mountTarget;
        this.fileSystemType = builder.fileSystemType;
        this.flags = builder.flags;
        this.moduleName = builder.moduleName;
        this.moduleFilePath = builder.moduleFilePath;
        this.moduleSha256 = builder.moduleSha256;
        this.shellHistoryFilePath = builder.shellHistoryFilePath;
        this.targetProcess = builder.targetProcess;
        this.addressFamily = builder.addressFamily;
        this.ianaProtocolNumber = builder.ianaProtocolNumber;
        this.memoryRegions = builder.memoryRegions;
    }

    public final ProcessDetails modifyingProcess() {
        return this.modifyingProcess;
    }

    public final Instant modifiedAt() {
        return this.modifiedAt;
    }

    public final String scriptPath() {
        return this.scriptPath;
    }

    public final String libraryPath() {
        return this.libraryPath;
    }

    public final String ldPreloadValue() {
        return this.ldPreloadValue;
    }

    public final String socketPath() {
        return this.socketPath;
    }

    public final String runcBinaryPath() {
        return this.runcBinaryPath;
    }

    public final String releaseAgentPath() {
        return this.releaseAgentPath;
    }

    public final String mountSource() {
        return this.mountSource;
    }

    public final String mountTarget() {
        return this.mountTarget;
    }

    public final String fileSystemType() {
        return this.fileSystemType;
    }

    public final boolean hasFlags() {
        return this.flags != null && !(this.flags instanceof SdkAutoConstructList);
    }

    public final List<String> flags() {
        return this.flags;
    }

    public final String moduleName() {
        return this.moduleName;
    }

    public final String moduleFilePath() {
        return this.moduleFilePath;
    }

    public final String moduleSha256() {
        return this.moduleSha256;
    }

    public final String shellHistoryFilePath() {
        return this.shellHistoryFilePath;
    }

    public final ProcessDetails targetProcess() {
        return this.targetProcess;
    }

    public final String addressFamily() {
        return this.addressFamily;
    }

    public final Integer ianaProtocolNumber() {
        return this.ianaProtocolNumber;
    }

    public final boolean hasMemoryRegions() {
        return this.memoryRegions != null && !(this.memoryRegions instanceof SdkAutoConstructList);
    }

    public final List<String> memoryRegions() {
        return this.memoryRegions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.modifyingProcess());
        hashCode = 31 * hashCode + Objects.hashCode(this.modifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.scriptPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.libraryPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.ldPreloadValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.socketPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.runcBinaryPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.releaseAgentPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.mountSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.mountTarget());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSystemType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFlags() ? this.flags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.moduleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.moduleFilePath());
        hashCode = 31 * hashCode + Objects.hashCode(this.moduleSha256());
        hashCode = 31 * hashCode + Objects.hashCode(this.shellHistoryFilePath());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetProcess());
        hashCode = 31 * hashCode + Objects.hashCode(this.addressFamily());
        hashCode = 31 * hashCode + Objects.hashCode(this.ianaProtocolNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMemoryRegions() ? this.memoryRegions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuntimeContext)) {
            return false;
        }
        RuntimeContext other = (RuntimeContext)obj;
        return Objects.equals(this.modifyingProcess(), other.modifyingProcess()) && Objects.equals(this.modifiedAt(), other.modifiedAt()) && Objects.equals(this.scriptPath(), other.scriptPath()) && Objects.equals(this.libraryPath(), other.libraryPath()) && Objects.equals(this.ldPreloadValue(), other.ldPreloadValue()) && Objects.equals(this.socketPath(), other.socketPath()) && Objects.equals(this.runcBinaryPath(), other.runcBinaryPath()) && Objects.equals(this.releaseAgentPath(), other.releaseAgentPath()) && Objects.equals(this.mountSource(), other.mountSource()) && Objects.equals(this.mountTarget(), other.mountTarget()) && Objects.equals(this.fileSystemType(), other.fileSystemType()) && this.hasFlags() == other.hasFlags() && Objects.equals(this.flags(), other.flags()) && Objects.equals(this.moduleName(), other.moduleName()) && Objects.equals(this.moduleFilePath(), other.moduleFilePath()) && Objects.equals(this.moduleSha256(), other.moduleSha256()) && Objects.equals(this.shellHistoryFilePath(), other.shellHistoryFilePath()) && Objects.equals(this.targetProcess(), other.targetProcess()) && Objects.equals(this.addressFamily(), other.addressFamily()) && Objects.equals(this.ianaProtocolNumber(), other.ianaProtocolNumber()) && this.hasMemoryRegions() == other.hasMemoryRegions() && Objects.equals(this.memoryRegions(), other.memoryRegions());
    }

    public final String toString() {
        return ToString.builder((String)"RuntimeContext").add("ModifyingProcess", (Object)this.modifyingProcess()).add("ModifiedAt", (Object)this.modifiedAt()).add("ScriptPath", (Object)this.scriptPath()).add("LibraryPath", (Object)this.libraryPath()).add("LdPreloadValue", (Object)this.ldPreloadValue()).add("SocketPath", (Object)this.socketPath()).add("RuncBinaryPath", (Object)this.runcBinaryPath()).add("ReleaseAgentPath", (Object)this.releaseAgentPath()).add("MountSource", (Object)this.mountSource()).add("MountTarget", (Object)this.mountTarget()).add("FileSystemType", (Object)this.fileSystemType()).add("Flags", this.hasFlags() ? this.flags() : null).add("ModuleName", (Object)this.moduleName()).add("ModuleFilePath", (Object)this.moduleFilePath()).add("ModuleSha256", (Object)this.moduleSha256()).add("ShellHistoryFilePath", (Object)this.shellHistoryFilePath()).add("TargetProcess", (Object)this.targetProcess()).add("AddressFamily", (Object)this.addressFamily()).add("IanaProtocolNumber", (Object)this.ianaProtocolNumber()).add("MemoryRegions", this.hasMemoryRegions() ? this.memoryRegions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ModifyingProcess": {
                return Optional.ofNullable(clazz.cast(this.modifyingProcess()));
            }
            case "ModifiedAt": {
                return Optional.ofNullable(clazz.cast(this.modifiedAt()));
            }
            case "ScriptPath": {
                return Optional.ofNullable(clazz.cast(this.scriptPath()));
            }
            case "LibraryPath": {
                return Optional.ofNullable(clazz.cast(this.libraryPath()));
            }
            case "LdPreloadValue": {
                return Optional.ofNullable(clazz.cast(this.ldPreloadValue()));
            }
            case "SocketPath": {
                return Optional.ofNullable(clazz.cast(this.socketPath()));
            }
            case "RuncBinaryPath": {
                return Optional.ofNullable(clazz.cast(this.runcBinaryPath()));
            }
            case "ReleaseAgentPath": {
                return Optional.ofNullable(clazz.cast(this.releaseAgentPath()));
            }
            case "MountSource": {
                return Optional.ofNullable(clazz.cast(this.mountSource()));
            }
            case "MountTarget": {
                return Optional.ofNullable(clazz.cast(this.mountTarget()));
            }
            case "FileSystemType": {
                return Optional.ofNullable(clazz.cast(this.fileSystemType()));
            }
            case "Flags": {
                return Optional.ofNullable(clazz.cast(this.flags()));
            }
            case "ModuleName": {
                return Optional.ofNullable(clazz.cast(this.moduleName()));
            }
            case "ModuleFilePath": {
                return Optional.ofNullable(clazz.cast(this.moduleFilePath()));
            }
            case "ModuleSha256": {
                return Optional.ofNullable(clazz.cast(this.moduleSha256()));
            }
            case "ShellHistoryFilePath": {
                return Optional.ofNullable(clazz.cast(this.shellHistoryFilePath()));
            }
            case "TargetProcess": {
                return Optional.ofNullable(clazz.cast(this.targetProcess()));
            }
            case "AddressFamily": {
                return Optional.ofNullable(clazz.cast(this.addressFamily()));
            }
            case "IanaProtocolNumber": {
                return Optional.ofNullable(clazz.cast(this.ianaProtocolNumber()));
            }
            case "MemoryRegions": {
                return Optional.ofNullable(clazz.cast(this.memoryRegions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RuntimeContext, T> g) {
        return obj -> g.apply((RuntimeContext)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ProcessDetails modifyingProcess;
        private Instant modifiedAt;
        private String scriptPath;
        private String libraryPath;
        private String ldPreloadValue;
        private String socketPath;
        private String runcBinaryPath;
        private String releaseAgentPath;
        private String mountSource;
        private String mountTarget;
        private String fileSystemType;
        private List<String> flags = DefaultSdkAutoConstructList.getInstance();
        private String moduleName;
        private String moduleFilePath;
        private String moduleSha256;
        private String shellHistoryFilePath;
        private ProcessDetails targetProcess;
        private String addressFamily;
        private Integer ianaProtocolNumber;
        private List<String> memoryRegions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RuntimeContext model) {
            this.modifyingProcess(model.modifyingProcess);
            this.modifiedAt(model.modifiedAt);
            this.scriptPath(model.scriptPath);
            this.libraryPath(model.libraryPath);
            this.ldPreloadValue(model.ldPreloadValue);
            this.socketPath(model.socketPath);
            this.runcBinaryPath(model.runcBinaryPath);
            this.releaseAgentPath(model.releaseAgentPath);
            this.mountSource(model.mountSource);
            this.mountTarget(model.mountTarget);
            this.fileSystemType(model.fileSystemType);
            this.flags(model.flags);
            this.moduleName(model.moduleName);
            this.moduleFilePath(model.moduleFilePath);
            this.moduleSha256(model.moduleSha256);
            this.shellHistoryFilePath(model.shellHistoryFilePath);
            this.targetProcess(model.targetProcess);
            this.addressFamily(model.addressFamily);
            this.ianaProtocolNumber(model.ianaProtocolNumber);
            this.memoryRegions(model.memoryRegions);
        }

        public final ProcessDetails.Builder getModifyingProcess() {
            return this.modifyingProcess != null ? this.modifyingProcess.toBuilder() : null;
        }

        public final void setModifyingProcess(ProcessDetails.BuilderImpl modifyingProcess) {
            this.modifyingProcess = modifyingProcess != null ? modifyingProcess.build() : null;
        }

        @Override
        public final Builder modifyingProcess(ProcessDetails modifyingProcess) {
            this.modifyingProcess = modifyingProcess;
            return this;
        }

        public final Instant getModifiedAt() {
            return this.modifiedAt;
        }

        public final void setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        @Override
        public final Builder modifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public final String getScriptPath() {
            return this.scriptPath;
        }

        public final void setScriptPath(String scriptPath) {
            this.scriptPath = scriptPath;
        }

        @Override
        public final Builder scriptPath(String scriptPath) {
            this.scriptPath = scriptPath;
            return this;
        }

        public final String getLibraryPath() {
            return this.libraryPath;
        }

        public final void setLibraryPath(String libraryPath) {
            this.libraryPath = libraryPath;
        }

        @Override
        public final Builder libraryPath(String libraryPath) {
            this.libraryPath = libraryPath;
            return this;
        }

        public final String getLdPreloadValue() {
            return this.ldPreloadValue;
        }

        public final void setLdPreloadValue(String ldPreloadValue) {
            this.ldPreloadValue = ldPreloadValue;
        }

        @Override
        public final Builder ldPreloadValue(String ldPreloadValue) {
            this.ldPreloadValue = ldPreloadValue;
            return this;
        }

        public final String getSocketPath() {
            return this.socketPath;
        }

        public final void setSocketPath(String socketPath) {
            this.socketPath = socketPath;
        }

        @Override
        public final Builder socketPath(String socketPath) {
            this.socketPath = socketPath;
            return this;
        }

        public final String getRuncBinaryPath() {
            return this.runcBinaryPath;
        }

        public final void setRuncBinaryPath(String runcBinaryPath) {
            this.runcBinaryPath = runcBinaryPath;
        }

        @Override
        public final Builder runcBinaryPath(String runcBinaryPath) {
            this.runcBinaryPath = runcBinaryPath;
            return this;
        }

        public final String getReleaseAgentPath() {
            return this.releaseAgentPath;
        }

        public final void setReleaseAgentPath(String releaseAgentPath) {
            this.releaseAgentPath = releaseAgentPath;
        }

        @Override
        public final Builder releaseAgentPath(String releaseAgentPath) {
            this.releaseAgentPath = releaseAgentPath;
            return this;
        }

        public final String getMountSource() {
            return this.mountSource;
        }

        public final void setMountSource(String mountSource) {
            this.mountSource = mountSource;
        }

        @Override
        public final Builder mountSource(String mountSource) {
            this.mountSource = mountSource;
            return this;
        }

        public final String getMountTarget() {
            return this.mountTarget;
        }

        public final void setMountTarget(String mountTarget) {
            this.mountTarget = mountTarget;
        }

        @Override
        public final Builder mountTarget(String mountTarget) {
            this.mountTarget = mountTarget;
            return this;
        }

        public final String getFileSystemType() {
            return this.fileSystemType;
        }

        public final void setFileSystemType(String fileSystemType) {
            this.fileSystemType = fileSystemType;
        }

        @Override
        public final Builder fileSystemType(String fileSystemType) {
            this.fileSystemType = fileSystemType;
            return this;
        }

        public final Collection<String> getFlags() {
            if (this.flags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.flags;
        }

        public final void setFlags(Collection<String> flags) {
            this.flags = FlagsListCopier.copy(flags);
        }

        @Override
        public final Builder flags(Collection<String> flags) {
            this.flags = FlagsListCopier.copy(flags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flags(String ... flags) {
            this.flags(Arrays.asList(flags));
            return this;
        }

        public final String getModuleName() {
            return this.moduleName;
        }

        public final void setModuleName(String moduleName) {
            this.moduleName = moduleName;
        }

        @Override
        public final Builder moduleName(String moduleName) {
            this.moduleName = moduleName;
            return this;
        }

        public final String getModuleFilePath() {
            return this.moduleFilePath;
        }

        public final void setModuleFilePath(String moduleFilePath) {
            this.moduleFilePath = moduleFilePath;
        }

        @Override
        public final Builder moduleFilePath(String moduleFilePath) {
            this.moduleFilePath = moduleFilePath;
            return this;
        }

        public final String getModuleSha256() {
            return this.moduleSha256;
        }

        public final void setModuleSha256(String moduleSha256) {
            this.moduleSha256 = moduleSha256;
        }

        @Override
        public final Builder moduleSha256(String moduleSha256) {
            this.moduleSha256 = moduleSha256;
            return this;
        }

        public final String getShellHistoryFilePath() {
            return this.shellHistoryFilePath;
        }

        public final void setShellHistoryFilePath(String shellHistoryFilePath) {
            this.shellHistoryFilePath = shellHistoryFilePath;
        }

        @Override
        public final Builder shellHistoryFilePath(String shellHistoryFilePath) {
            this.shellHistoryFilePath = shellHistoryFilePath;
            return this;
        }

        public final ProcessDetails.Builder getTargetProcess() {
            return this.targetProcess != null ? this.targetProcess.toBuilder() : null;
        }

        public final void setTargetProcess(ProcessDetails.BuilderImpl targetProcess) {
            this.targetProcess = targetProcess != null ? targetProcess.build() : null;
        }

        @Override
        public final Builder targetProcess(ProcessDetails targetProcess) {
            this.targetProcess = targetProcess;
            return this;
        }

        public final String getAddressFamily() {
            return this.addressFamily;
        }

        public final void setAddressFamily(String addressFamily) {
            this.addressFamily = addressFamily;
        }

        @Override
        public final Builder addressFamily(String addressFamily) {
            this.addressFamily = addressFamily;
            return this;
        }

        public final Integer getIanaProtocolNumber() {
            return this.ianaProtocolNumber;
        }

        public final void setIanaProtocolNumber(Integer ianaProtocolNumber) {
            this.ianaProtocolNumber = ianaProtocolNumber;
        }

        @Override
        public final Builder ianaProtocolNumber(Integer ianaProtocolNumber) {
            this.ianaProtocolNumber = ianaProtocolNumber;
            return this;
        }

        public final Collection<String> getMemoryRegions() {
            if (this.memoryRegions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.memoryRegions;
        }

        public final void setMemoryRegions(Collection<String> memoryRegions) {
            this.memoryRegions = MemoryRegionsListCopier.copy(memoryRegions);
        }

        @Override
        public final Builder memoryRegions(Collection<String> memoryRegions) {
            this.memoryRegions = MemoryRegionsListCopier.copy(memoryRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memoryRegions(String ... memoryRegions) {
            this.memoryRegions(Arrays.asList(memoryRegions));
            return this;
        }

        public RuntimeContext build() {
            return new RuntimeContext(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RuntimeContext> {
        public Builder modifyingProcess(ProcessDetails var1);

        default public Builder modifyingProcess(Consumer<ProcessDetails.Builder> modifyingProcess) {
            return this.modifyingProcess((ProcessDetails)((ProcessDetails.Builder)ProcessDetails.builder().applyMutation(modifyingProcess)).build());
        }

        public Builder modifiedAt(Instant var1);

        public Builder scriptPath(String var1);

        public Builder libraryPath(String var1);

        public Builder ldPreloadValue(String var1);

        public Builder socketPath(String var1);

        public Builder runcBinaryPath(String var1);

        public Builder releaseAgentPath(String var1);

        public Builder mountSource(String var1);

        public Builder mountTarget(String var1);

        public Builder fileSystemType(String var1);

        public Builder flags(Collection<String> var1);

        public Builder flags(String ... var1);

        public Builder moduleName(String var1);

        public Builder moduleFilePath(String var1);

        public Builder moduleSha256(String var1);

        public Builder shellHistoryFilePath(String var1);

        public Builder targetProcess(ProcessDetails var1);

        default public Builder targetProcess(Consumer<ProcessDetails.Builder> targetProcess) {
            return this.targetProcess((ProcessDetails)((ProcessDetails.Builder)ProcessDetails.builder().applyMutation(targetProcess)).build());
        }

        public Builder addressFamily(String var1);

        public Builder ianaProtocolNumber(Integer var1);

        public Builder memoryRegions(Collection<String> var1);

        public Builder memoryRegions(String ... var1);
    }
}

