/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about the remote Amazon Web Services account that made the API call.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RemoteAccountDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<RemoteAccountDetails.Builder, RemoteAccountDetails> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(RemoteAccountDetails::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final SdkField<Boolean> AFFILIATED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Affiliated").getter(getter(RemoteAccountDetails::affiliated)).setter(setter(Builder::affiliated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("affiliated").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            AFFILIATED_FIELD));

    private static final long serialVersionUID = 1L;

    private final String accountId;

    private final Boolean affiliated;

    private RemoteAccountDetails(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.affiliated = builder.affiliated;
    }

    /**
     * <p>
     * The Amazon Web Services account ID of the remote API caller.
     * </p>
     * 
     * @return The Amazon Web Services account ID of the remote API caller.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * Details on whether the Amazon Web Services account of the remote API caller is related to your GuardDuty
     * environment. If this value is <code>True</code> the API caller is affiliated to your account in some way. If it
     * is <code>False</code> the API caller is from outside your environment.
     * </p>
     * 
     * @return Details on whether the Amazon Web Services account of the remote API caller is related to your GuardDuty
     *         environment. If this value is <code>True</code> the API caller is affiliated to your account in some way.
     *         If it is <code>False</code> the API caller is from outside your environment.
     */
    public final Boolean affiliated() {
        return affiliated;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(affiliated());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoteAccountDetails)) {
            return false;
        }
        RemoteAccountDetails other = (RemoteAccountDetails) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(affiliated(), other.affiliated());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RemoteAccountDetails").add("AccountId", accountId()).add("Affiliated", affiliated()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "Affiliated":
            return Optional.ofNullable(clazz.cast(affiliated()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RemoteAccountDetails, T> g) {
        return obj -> g.apply((RemoteAccountDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RemoteAccountDetails> {
        /**
         * <p>
         * The Amazon Web Services account ID of the remote API caller.
         * </p>
         * 
         * @param accountId
         *        The Amazon Web Services account ID of the remote API caller.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * Details on whether the Amazon Web Services account of the remote API caller is related to your GuardDuty
         * environment. If this value is <code>True</code> the API caller is affiliated to your account in some way. If
         * it is <code>False</code> the API caller is from outside your environment.
         * </p>
         * 
         * @param affiliated
         *        Details on whether the Amazon Web Services account of the remote API caller is related to your
         *        GuardDuty environment. If this value is <code>True</code> the API caller is affiliated to your account
         *        in some way. If it is <code>False</code> the API caller is from outside your environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder affiliated(Boolean affiliated);
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private Boolean affiliated;

        private BuilderImpl() {
        }

        private BuilderImpl(RemoteAccountDetails model) {
            accountId(model.accountId);
            affiliated(model.affiliated);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final Boolean getAffiliated() {
            return affiliated;
        }

        public final void setAffiliated(Boolean affiliated) {
            this.affiliated = affiliated;
        }

        @Override
        public final Builder affiliated(Boolean affiliated) {
            this.affiliated = affiliated;
            return this;
        }

        @Override
        public RemoteAccountDetails build() {
            return new RemoteAccountDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
