/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.guardduty.DefaultGuardDutyBaseClientBuilder;
import software.amazon.awssdk.services.guardduty.DefaultGuardDutyClient;
import software.amazon.awssdk.services.guardduty.GuardDutyClient;
import software.amazon.awssdk.services.guardduty.GuardDutyClientBuilder;
import software.amazon.awssdk.services.guardduty.GuardDutyServiceClientConfiguration;
import software.amazon.awssdk.services.guardduty.endpoints.GuardDutyEndpointProvider;

@SdkInternalApi
final class DefaultGuardDutyClientBuilder
extends DefaultGuardDutyBaseClientBuilder<GuardDutyClientBuilder, GuardDutyClient>
implements GuardDutyClientBuilder {
    DefaultGuardDutyClientBuilder() {
    }

    @Override
    public DefaultGuardDutyClientBuilder endpointProvider(GuardDutyEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final GuardDutyClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultGuardDutyClientBuilder.validateClientOptions(clientConfiguration);
        GuardDutyServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultGuardDutyClient client = new DefaultGuardDutyClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private GuardDutyServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return GuardDutyServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

