/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.guardduty.model.FindingCriteria;
import software.amazon.awssdk.services.guardduty.model.FindingStatisticType;
import software.amazon.awssdk.services.guardduty.model.FindingStatisticTypesCopier;
import software.amazon.awssdk.services.guardduty.model.GuardDutyRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetFindingsStatisticsRequest
extends GuardDutyRequest
implements ToCopyableBuilder<Builder, GetFindingsStatisticsRequest> {
    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetFindingsStatisticsRequest.getter(GetFindingsStatisticsRequest::detectorId)).setter(GetFindingsStatisticsRequest.setter(Builder::detectorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("detectorId").build()}).build();
    private static final SdkField<FindingCriteria> FINDING_CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(GetFindingsStatisticsRequest.getter(GetFindingsStatisticsRequest::findingCriteria)).setter(GetFindingsStatisticsRequest.setter(Builder::findingCriteria)).constructor(FindingCriteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingCriteria").build()}).build();
    private static final SdkField<List<String>> FINDING_STATISTIC_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetFindingsStatisticsRequest.getter(GetFindingsStatisticsRequest::findingStatisticTypesAsStrings)).setter(GetFindingsStatisticsRequest.setter(Builder::findingStatisticTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingStatisticTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_ID_FIELD, FINDING_CRITERIA_FIELD, FINDING_STATISTIC_TYPES_FIELD));
    private final String detectorId;
    private final FindingCriteria findingCriteria;
    private final List<String> findingStatisticTypes;

    private GetFindingsStatisticsRequest(BuilderImpl builder) {
        super(builder);
        this.detectorId = builder.detectorId;
        this.findingCriteria = builder.findingCriteria;
        this.findingStatisticTypes = builder.findingStatisticTypes;
    }

    public String detectorId() {
        return this.detectorId;
    }

    public FindingCriteria findingCriteria() {
        return this.findingCriteria;
    }

    public List<FindingStatisticType> findingStatisticTypes() {
        return TypeConverter.convert(this.findingStatisticTypes, FindingStatisticType::fromValue);
    }

    public List<String> findingStatisticTypesAsStrings() {
        return this.findingStatisticTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.findingCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(this.findingStatisticTypesAsStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFindingsStatisticsRequest)) {
            return false;
        }
        GetFindingsStatisticsRequest other = (GetFindingsStatisticsRequest)((Object)obj);
        return Objects.equals(this.detectorId(), other.detectorId()) && Objects.equals(this.findingCriteria(), other.findingCriteria()) && Objects.equals(this.findingStatisticTypesAsStrings(), other.findingStatisticTypesAsStrings());
    }

    public String toString() {
        return ToString.builder((String)"GetFindingsStatisticsRequest").add("DetectorId", (Object)this.detectorId()).add("FindingCriteria", (Object)this.findingCriteria()).add("FindingStatisticTypes", this.findingStatisticTypesAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DetectorId": {
                return Optional.ofNullable(clazz.cast(this.detectorId()));
            }
            case "FindingCriteria": {
                return Optional.ofNullable(clazz.cast(this.findingCriteria()));
            }
            case "FindingStatisticTypes": {
                return Optional.ofNullable(clazz.cast(this.findingStatisticTypesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetFindingsStatisticsRequest, T> g) {
        return obj -> g.apply((GetFindingsStatisticsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GuardDutyRequest.BuilderImpl
    implements Builder {
        private String detectorId;
        private FindingCriteria findingCriteria;
        private List<String> findingStatisticTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetFindingsStatisticsRequest model) {
            super(model);
            this.detectorId(model.detectorId);
            this.findingCriteria(model.findingCriteria);
            this.findingStatisticTypesWithStrings(model.findingStatisticTypes);
        }

        public final String getDetectorId() {
            return this.detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        public final FindingCriteria.Builder getFindingCriteria() {
            return this.findingCriteria != null ? this.findingCriteria.toBuilder() : null;
        }

        @Override
        public final Builder findingCriteria(FindingCriteria findingCriteria) {
            this.findingCriteria = findingCriteria;
            return this;
        }

        public final void setFindingCriteria(FindingCriteria.BuilderImpl findingCriteria) {
            this.findingCriteria = findingCriteria != null ? findingCriteria.build() : null;
        }

        public final Collection<String> getFindingStatisticTypes() {
            return this.findingStatisticTypes;
        }

        @Override
        public final Builder findingStatisticTypesWithStrings(Collection<String> findingStatisticTypes) {
            this.findingStatisticTypes = FindingStatisticTypesCopier.copy(findingStatisticTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingStatisticTypesWithStrings(String ... findingStatisticTypes) {
            this.findingStatisticTypesWithStrings(Arrays.asList(findingStatisticTypes));
            return this;
        }

        @Override
        public final Builder findingStatisticTypes(Collection<FindingStatisticType> findingStatisticTypes) {
            this.findingStatisticTypes = FindingStatisticTypesCopier.copyEnumToString(findingStatisticTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingStatisticTypes(FindingStatisticType ... findingStatisticTypes) {
            this.findingStatisticTypes(Arrays.asList(findingStatisticTypes));
            return this;
        }

        public final void setFindingStatisticTypes(Collection<String> findingStatisticTypes) {
            this.findingStatisticTypes = FindingStatisticTypesCopier.copy(findingStatisticTypes);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetFindingsStatisticsRequest build() {
            return new GetFindingsStatisticsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GuardDutyRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetFindingsStatisticsRequest> {
        public Builder detectorId(String var1);

        public Builder findingCriteria(FindingCriteria var1);

        default public Builder findingCriteria(Consumer<FindingCriteria.Builder> findingCriteria) {
            return this.findingCriteria((FindingCriteria)((FindingCriteria.Builder)FindingCriteria.builder().applyMutation(findingCriteria)).build());
        }

        public Builder findingStatisticTypesWithStrings(Collection<String> var1);

        public Builder findingStatisticTypesWithStrings(String ... var1);

        public Builder findingStatisticTypes(Collection<FindingStatisticType> var1);

        public Builder findingStatisticTypes(FindingStatisticType ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

