/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum IpSetFormat {
    TXT("TXT"),
    STIX("STIX"),
    OTX_CSV("OTX_CSV"),
    ALIEN_VAULT("ALIEN_VAULT"),
    PROOF_POINT("PROOF_POINT"),
    FIRE_EYE("FIRE_EYE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private IpSetFormat(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static IpSetFormat fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(IpSetFormat.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<IpSetFormat> knownValues() {
        return Stream.of(IpSetFormat.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

