/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.guardduty.model.AccountIdsCopier;
import software.amazon.awssdk.services.guardduty.model.DataSource;
import software.amazon.awssdk.services.guardduty.model.DataSourceListCopier;
import software.amazon.awssdk.services.guardduty.model.ResourceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UsageCriteria
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UsageCriteria> {
    private static final SdkField<List<String>> ACCOUNT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AccountIds").getter(UsageCriteria.getter(UsageCriteria::accountIds)).setter(UsageCriteria.setter(Builder::accountIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> DATA_SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DataSources").getter(UsageCriteria.getter(UsageCriteria::dataSourcesAsStrings)).setter(UsageCriteria.setter(Builder::dataSourcesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Resources").getter(UsageCriteria.getter(UsageCriteria::resources)).setter(UsageCriteria.setter(Builder::resources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_IDS_FIELD, DATA_SOURCES_FIELD, RESOURCES_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> accountIds;
    private final List<String> dataSources;
    private final List<String> resources;

    private UsageCriteria(BuilderImpl builder) {
        this.accountIds = builder.accountIds;
        this.dataSources = builder.dataSources;
        this.resources = builder.resources;
    }

    public final boolean hasAccountIds() {
        return this.accountIds != null && !(this.accountIds instanceof SdkAutoConstructList);
    }

    public final List<String> accountIds() {
        return this.accountIds;
    }

    public final List<DataSource> dataSources() {
        return DataSourceListCopier.copyStringToEnum(this.dataSources);
    }

    public final boolean hasDataSources() {
        return this.dataSources != null && !(this.dataSources instanceof SdkAutoConstructList);
    }

    public final List<String> dataSourcesAsStrings() {
        return this.dataSources;
    }

    public final boolean hasResources() {
        return this.resources != null && !(this.resources instanceof SdkAutoConstructList);
    }

    public final List<String> resources() {
        return this.resources;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccountIds() ? this.accountIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDataSources() ? this.dataSourcesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResources() ? this.resources() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UsageCriteria)) {
            return false;
        }
        UsageCriteria other = (UsageCriteria)obj;
        return this.hasAccountIds() == other.hasAccountIds() && Objects.equals(this.accountIds(), other.accountIds()) && this.hasDataSources() == other.hasDataSources() && Objects.equals(this.dataSourcesAsStrings(), other.dataSourcesAsStrings()) && this.hasResources() == other.hasResources() && Objects.equals(this.resources(), other.resources());
    }

    public final String toString() {
        return ToString.builder((String)"UsageCriteria").add("AccountIds", this.hasAccountIds() ? this.accountIds() : null).add("DataSources", this.hasDataSources() ? this.dataSourcesAsStrings() : null).add("Resources", this.hasResources() ? this.resources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountIds": {
                return Optional.ofNullable(clazz.cast(this.accountIds()));
            }
            case "DataSources": {
                return Optional.ofNullable(clazz.cast(this.dataSourcesAsStrings()));
            }
            case "Resources": {
                return Optional.ofNullable(clazz.cast(this.resources()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UsageCriteria, T> g) {
        return obj -> g.apply((UsageCriteria)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> accountIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> dataSources = DefaultSdkAutoConstructList.getInstance();
        private List<String> resources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UsageCriteria model) {
            this.accountIds(model.accountIds);
            this.dataSourcesWithStrings(model.dataSources);
            this.resources(model.resources);
        }

        public final Collection<String> getAccountIds() {
            if (this.accountIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.accountIds;
        }

        public final void setAccountIds(Collection<String> accountIds) {
            this.accountIds = AccountIdsCopier.copy(accountIds);
        }

        @Override
        @Transient
        public final Builder accountIds(Collection<String> accountIds) {
            this.accountIds = AccountIdsCopier.copy(accountIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder accountIds(String ... accountIds) {
            this.accountIds(Arrays.asList(accountIds));
            return this;
        }

        public final Collection<String> getDataSources() {
            if (this.dataSources instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dataSources;
        }

        public final void setDataSources(Collection<String> dataSources) {
            this.dataSources = DataSourceListCopier.copy(dataSources);
        }

        @Override
        @Transient
        public final Builder dataSourcesWithStrings(Collection<String> dataSources) {
            this.dataSources = DataSourceListCopier.copy(dataSources);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder dataSourcesWithStrings(String ... dataSources) {
            this.dataSourcesWithStrings(Arrays.asList(dataSources));
            return this;
        }

        @Override
        @Transient
        public final Builder dataSources(Collection<DataSource> dataSources) {
            this.dataSources = DataSourceListCopier.copyEnumToString(dataSources);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder dataSources(DataSource ... dataSources) {
            this.dataSources(Arrays.asList(dataSources));
            return this;
        }

        public final Collection<String> getResources() {
            if (this.resources instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resources;
        }

        public final void setResources(Collection<String> resources) {
            this.resources = ResourceListCopier.copy(resources);
        }

        @Override
        @Transient
        public final Builder resources(Collection<String> resources) {
            this.resources = ResourceListCopier.copy(resources);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder resources(String ... resources) {
            this.resources(Arrays.asList(resources));
            return this;
        }

        public UsageCriteria build() {
            return new UsageCriteria(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UsageCriteria> {
        public Builder accountIds(Collection<String> var1);

        public Builder accountIds(String ... var1);

        public Builder dataSourcesWithStrings(Collection<String> var1);

        public Builder dataSourcesWithStrings(String ... var1);

        public Builder dataSources(Collection<DataSource> var1);

        public Builder dataSources(DataSource ... var1);

        public Builder resources(Collection<String> var1);

        public Builder resources(String ... var1);
    }
}

