/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3LogsConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3LogsConfiguration> {
    private static final SdkField<Boolean> ENABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Enable").getter(S3LogsConfiguration.getter(S3LogsConfiguration::enable)).setter(S3LogsConfiguration.setter(Builder::enable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enable").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean enable;

    private S3LogsConfiguration(BuilderImpl builder) {
        this.enable = builder.enable;
    }

    public Boolean enable() {
        return this.enable;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enable());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3LogsConfiguration)) {
            return false;
        }
        S3LogsConfiguration other = (S3LogsConfiguration)obj;
        return Objects.equals(this.enable(), other.enable());
    }

    public String toString() {
        return ToString.builder((String)"S3LogsConfiguration").add("Enable", (Object)this.enable()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Enable": {
                return Optional.ofNullable(clazz.cast(this.enable()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3LogsConfiguration, T> g) {
        return obj -> g.apply((S3LogsConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enable;

        private BuilderImpl() {
        }

        private BuilderImpl(S3LogsConfiguration model) {
            this.enable(model.enable);
        }

        public final Boolean getEnable() {
            return this.enable;
        }

        @Override
        public final Builder enable(Boolean enable) {
            this.enable = enable;
            return this;
        }

        public final void setEnable(Boolean enable) {
            this.enable = enable;
        }

        public S3LogsConfiguration build() {
            return new S3LogsConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3LogsConfiguration> {
        public Builder enable(Boolean var1);
    }
}

