/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.guardduty.model.DestinationProperties;
import software.amazon.awssdk.services.guardduty.model.DestinationType;
import software.amazon.awssdk.services.guardduty.model.GuardDutyRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreatePublishingDestinationRequest
extends GuardDutyRequest
implements ToCopyableBuilder<Builder, CreatePublishingDestinationRequest> {
    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DetectorId").getter(CreatePublishingDestinationRequest.getter(CreatePublishingDestinationRequest::detectorId)).setter(CreatePublishingDestinationRequest.setter(Builder::detectorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("detectorId").build()}).build();
    private static final SdkField<String> DESTINATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationType").getter(CreatePublishingDestinationRequest.getter(CreatePublishingDestinationRequest::destinationTypeAsString)).setter(CreatePublishingDestinationRequest.setter(Builder::destinationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationType").build()}).build();
    private static final SdkField<DestinationProperties> DESTINATION_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DestinationProperties").getter(CreatePublishingDestinationRequest.getter(CreatePublishingDestinationRequest::destinationProperties)).setter(CreatePublishingDestinationRequest.setter(Builder::destinationProperties)).constructor(DestinationProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationProperties").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreatePublishingDestinationRequest.getter(CreatePublishingDestinationRequest::clientToken)).setter(CreatePublishingDestinationRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_ID_FIELD, DESTINATION_TYPE_FIELD, DESTINATION_PROPERTIES_FIELD, CLIENT_TOKEN_FIELD));
    private final String detectorId;
    private final String destinationType;
    private final DestinationProperties destinationProperties;
    private final String clientToken;

    private CreatePublishingDestinationRequest(BuilderImpl builder) {
        super(builder);
        this.detectorId = builder.detectorId;
        this.destinationType = builder.destinationType;
        this.destinationProperties = builder.destinationProperties;
        this.clientToken = builder.clientToken;
    }

    public String detectorId() {
        return this.detectorId;
    }

    public DestinationType destinationType() {
        return DestinationType.fromValue(this.destinationType);
    }

    public String destinationTypeAsString() {
        return this.destinationType;
    }

    public DestinationProperties destinationProperties() {
        return this.destinationProperties;
    }

    public String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePublishingDestinationRequest)) {
            return false;
        }
        CreatePublishingDestinationRequest other = (CreatePublishingDestinationRequest)((Object)obj);
        return Objects.equals(this.detectorId(), other.detectorId()) && Objects.equals(this.destinationTypeAsString(), other.destinationTypeAsString()) && Objects.equals(this.destinationProperties(), other.destinationProperties()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public String toString() {
        return ToString.builder((String)"CreatePublishingDestinationRequest").add("DetectorId", (Object)this.detectorId()).add("DestinationType", (Object)this.destinationTypeAsString()).add("DestinationProperties", (Object)this.destinationProperties()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DetectorId": {
                return Optional.ofNullable(clazz.cast(this.detectorId()));
            }
            case "DestinationType": {
                return Optional.ofNullable(clazz.cast(this.destinationTypeAsString()));
            }
            case "DestinationProperties": {
                return Optional.ofNullable(clazz.cast(this.destinationProperties()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreatePublishingDestinationRequest, T> g) {
        return obj -> g.apply((CreatePublishingDestinationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GuardDutyRequest.BuilderImpl
    implements Builder {
        private String detectorId;
        private String destinationType;
        private DestinationProperties destinationProperties;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePublishingDestinationRequest model) {
            super(model);
            this.detectorId(model.detectorId);
            this.destinationType(model.destinationType);
            this.destinationProperties(model.destinationProperties);
            this.clientToken(model.clientToken);
        }

        public final String getDetectorId() {
            return this.detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        public final String getDestinationType() {
            return this.destinationType;
        }

        @Override
        public final Builder destinationType(String destinationType) {
            this.destinationType = destinationType;
            return this;
        }

        @Override
        public final Builder destinationType(DestinationType destinationType) {
            this.destinationType(destinationType == null ? null : destinationType.toString());
            return this;
        }

        public final void setDestinationType(String destinationType) {
            this.destinationType = destinationType;
        }

        public final DestinationProperties.Builder getDestinationProperties() {
            return this.destinationProperties != null ? this.destinationProperties.toBuilder() : null;
        }

        @Override
        public final Builder destinationProperties(DestinationProperties destinationProperties) {
            this.destinationProperties = destinationProperties;
            return this;
        }

        public final void setDestinationProperties(DestinationProperties.BuilderImpl destinationProperties) {
            this.destinationProperties = destinationProperties != null ? destinationProperties.build() : null;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePublishingDestinationRequest build() {
            return new CreatePublishingDestinationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GuardDutyRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreatePublishingDestinationRequest> {
        public Builder detectorId(String var1);

        public Builder destinationType(String var1);

        public Builder destinationType(DestinationType var1);

        public Builder destinationProperties(DestinationProperties var1);

        default public Builder destinationProperties(Consumer<DestinationProperties.Builder> destinationProperties) {
            return this.destinationProperties((DestinationProperties)((DestinationProperties.Builder)DestinationProperties.builder().applyMutation(destinationProperties)).build());
        }

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

