/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.guardduty.model.GuardDutyRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateIpSetRequest
extends GuardDutyRequest
implements ToCopyableBuilder<Builder, UpdateIpSetRequest> {
    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DetectorId").getter(UpdateIpSetRequest.getter(UpdateIpSetRequest::detectorId)).setter(UpdateIpSetRequest.setter(Builder::detectorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("detectorId").build()}).build();
    private static final SdkField<String> IP_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpSetId").getter(UpdateIpSetRequest.getter(UpdateIpSetRequest::ipSetId)).setter(UpdateIpSetRequest.setter(Builder::ipSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ipSetId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateIpSetRequest.getter(UpdateIpSetRequest::name)).setter(UpdateIpSetRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Location").getter(UpdateIpSetRequest.getter(UpdateIpSetRequest::location)).setter(UpdateIpSetRequest.setter(Builder::location)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()}).build();
    private static final SdkField<Boolean> ACTIVATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Activate").getter(UpdateIpSetRequest.getter(UpdateIpSetRequest::activate)).setter(UpdateIpSetRequest.setter(Builder::activate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_ID_FIELD, IP_SET_ID_FIELD, NAME_FIELD, LOCATION_FIELD, ACTIVATE_FIELD));
    private final String detectorId;
    private final String ipSetId;
    private final String name;
    private final String location;
    private final Boolean activate;

    private UpdateIpSetRequest(BuilderImpl builder) {
        super(builder);
        this.detectorId = builder.detectorId;
        this.ipSetId = builder.ipSetId;
        this.name = builder.name;
        this.location = builder.location;
        this.activate = builder.activate;
    }

    public String detectorId() {
        return this.detectorId;
    }

    public String ipSetId() {
        return this.ipSetId;
    }

    public String name() {
        return this.name;
    }

    public String location() {
        return this.location;
    }

    public Boolean activate() {
        return this.activate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.activate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateIpSetRequest)) {
            return false;
        }
        UpdateIpSetRequest other = (UpdateIpSetRequest)((Object)obj);
        return Objects.equals(this.detectorId(), other.detectorId()) && Objects.equals(this.ipSetId(), other.ipSetId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.location(), other.location()) && Objects.equals(this.activate(), other.activate());
    }

    public String toString() {
        return ToString.builder((String)"UpdateIpSetRequest").add("DetectorId", (Object)this.detectorId()).add("IpSetId", (Object)this.ipSetId()).add("Name", (Object)this.name()).add("Location", (Object)this.location()).add("Activate", (Object)this.activate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DetectorId": {
                return Optional.ofNullable(clazz.cast(this.detectorId()));
            }
            case "IpSetId": {
                return Optional.ofNullable(clazz.cast(this.ipSetId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
            case "Activate": {
                return Optional.ofNullable(clazz.cast(this.activate()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateIpSetRequest, T> g) {
        return obj -> g.apply((UpdateIpSetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GuardDutyRequest.BuilderImpl
    implements Builder {
        private String detectorId;
        private String ipSetId;
        private String name;
        private String location;
        private Boolean activate;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateIpSetRequest model) {
            super(model);
            this.detectorId(model.detectorId);
            this.ipSetId(model.ipSetId);
            this.name(model.name);
            this.location(model.location);
            this.activate(model.activate);
        }

        public final String getDetectorId() {
            return this.detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        public final String getIpSetId() {
            return this.ipSetId;
        }

        @Override
        public final Builder ipSetId(String ipSetId) {
            this.ipSetId = ipSetId;
            return this;
        }

        public final void setIpSetId(String ipSetId) {
            this.ipSetId = ipSetId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getLocation() {
            return this.location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        public final Boolean getActivate() {
            return this.activate;
        }

        @Override
        public final Builder activate(Boolean activate) {
            this.activate = activate;
            return this;
        }

        public final void setActivate(Boolean activate) {
            this.activate = activate;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateIpSetRequest build() {
            return new UpdateIpSetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GuardDutyRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateIpSetRequest> {
        public Builder detectorId(String var1);

        public Builder ipSetId(String var1);

        public Builder name(String var1);

        public Builder location(String var1);

        public Builder activate(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

