/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.guardduty.model.CountBySeverityCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FindingStatistics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FindingStatistics> {
    private static final SdkField<Map<String, Integer>> COUNT_BY_SEVERITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("CountBySeverity").getter(FindingStatistics.getter(FindingStatistics::countBySeverity)).setter(FindingStatistics.setter(Builder::countBySeverity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("countBySeverity").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COUNT_BY_SEVERITY_FIELD));
    private static final long serialVersionUID = 1L;
    private final Map<String, Integer> countBySeverity;

    private FindingStatistics(BuilderImpl builder) {
        this.countBySeverity = builder.countBySeverity;
    }

    public boolean hasCountBySeverity() {
        return this.countBySeverity != null && !(this.countBySeverity instanceof SdkAutoConstructMap);
    }

    public Map<String, Integer> countBySeverity() {
        return this.countBySeverity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCountBySeverity() ? this.countBySeverity() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FindingStatistics)) {
            return false;
        }
        FindingStatistics other = (FindingStatistics)obj;
        return this.hasCountBySeverity() == other.hasCountBySeverity() && Objects.equals(this.countBySeverity(), other.countBySeverity());
    }

    public String toString() {
        return ToString.builder((String)"FindingStatistics").add("CountBySeverity", this.hasCountBySeverity() ? this.countBySeverity() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CountBySeverity": {
                return Optional.ofNullable(clazz.cast(this.countBySeverity()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FindingStatistics, T> g) {
        return obj -> g.apply((FindingStatistics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, Integer> countBySeverity = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FindingStatistics model) {
            this.countBySeverity(model.countBySeverity);
        }

        public final Map<String, Integer> getCountBySeverity() {
            if (this.countBySeverity instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.countBySeverity;
        }

        @Override
        public final Builder countBySeverity(Map<String, Integer> countBySeverity) {
            this.countBySeverity = CountBySeverityCopier.copy(countBySeverity);
            return this;
        }

        public final void setCountBySeverity(Map<String, Integer> countBySeverity) {
            this.countBySeverity = CountBySeverityCopier.copy(countBySeverity);
        }

        public FindingStatistics build() {
            return new FindingStatistics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FindingStatistics> {
        public Builder countBySeverity(Map<String, Integer> var1);
    }
}

