/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.guardduty.GuardDutyClient;
import software.amazon.awssdk.services.guardduty.model.ListPublishingDestinationsRequest;
import software.amazon.awssdk.services.guardduty.model.ListPublishingDestinationsResponse;

public class ListPublishingDestinationsIterable
implements SdkIterable<ListPublishingDestinationsResponse> {
    private final GuardDutyClient client;
    private final ListPublishingDestinationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPublishingDestinationsIterable(GuardDutyClient client, ListPublishingDestinationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListPublishingDestinationsResponseFetcher();
    }

    public Iterator<ListPublishingDestinationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListPublishingDestinationsResponseFetcher
    implements SyncPageFetcher<ListPublishingDestinationsResponse> {
        private ListPublishingDestinationsResponseFetcher() {
        }

        public boolean hasNextPage(ListPublishingDestinationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPublishingDestinationsResponse nextPage(ListPublishingDestinationsResponse previousPage) {
            if (previousPage == null) {
                return ListPublishingDestinationsIterable.this.client.listPublishingDestinations(ListPublishingDestinationsIterable.this.firstRequest);
            }
            return ListPublishingDestinationsIterable.this.client.listPublishingDestinations((ListPublishingDestinationsRequest)((Object)ListPublishingDestinationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

